@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.sagemaker.kotlin.inputs

import com.pulumi.aws.sagemaker.inputs.DomainDefaultUserSettingsJupyterLabAppSettingsCustomImageArgs.builder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiNullFieldException
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.Int
import kotlin.String
import kotlin.Suppress
import kotlin.jvm.JvmName

/**
 *
 * @property appImageConfigName The name of the App Image Config.
 * @property imageName The name of the Custom Image.
 * @property imageVersionNumber The version number of the Custom Image.
 */
public data class DomainDefaultUserSettingsJupyterLabAppSettingsCustomImageArgs(
    public val appImageConfigName: Output<String>,
    public val imageName: Output<String>,
    public val imageVersionNumber: Output<Int>? = null,
) :
    ConvertibleToJava<com.pulumi.aws.sagemaker.inputs.DomainDefaultUserSettingsJupyterLabAppSettingsCustomImageArgs> {
    override fun toJava(): com.pulumi.aws.sagemaker.inputs.DomainDefaultUserSettingsJupyterLabAppSettingsCustomImageArgs =
        com.pulumi.aws.sagemaker.inputs.DomainDefaultUserSettingsJupyterLabAppSettingsCustomImageArgs.builder()
            .appImageConfigName(appImageConfigName.applyValue({ args0 -> args0 }))
            .imageName(imageName.applyValue({ args0 -> args0 }))
            .imageVersionNumber(imageVersionNumber?.applyValue({ args0 -> args0 })).build()
}

/**
 * Builder for [DomainDefaultUserSettingsJupyterLabAppSettingsCustomImageArgs].
 */
@PulumiTagMarker
public class DomainDefaultUserSettingsJupyterLabAppSettingsCustomImageArgsBuilder internal constructor() {
    private var appImageConfigName: Output<String>? = null

    private var imageName: Output<String>? = null

    private var imageVersionNumber: Output<Int>? = null

    /**
     * @param value The name of the App Image Config.
     */
    @JvmName("pyxffkgmrnfrtjaa")
    public suspend fun appImageConfigName(`value`: Output<String>) {
        this.appImageConfigName = value
    }

    /**
     * @param value The name of the Custom Image.
     */
    @JvmName("jjegfrvsjxrwpboe")
    public suspend fun imageName(`value`: Output<String>) {
        this.imageName = value
    }

    /**
     * @param value The version number of the Custom Image.
     */
    @JvmName("rgajfpwqngjrpwow")
    public suspend fun imageVersionNumber(`value`: Output<Int>) {
        this.imageVersionNumber = value
    }

    /**
     * @param value The name of the App Image Config.
     */
    @JvmName("pfvawbjvxyrxvawc")
    public suspend fun appImageConfigName(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.appImageConfigName = mapped
    }

    /**
     * @param value The name of the Custom Image.
     */
    @JvmName("omdbsdhivhpnqdrr")
    public suspend fun imageName(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.imageName = mapped
    }

    /**
     * @param value The version number of the Custom Image.
     */
    @JvmName("jqogipxgofddboxv")
    public suspend fun imageVersionNumber(`value`: Int?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.imageVersionNumber = mapped
    }

    internal fun build(): DomainDefaultUserSettingsJupyterLabAppSettingsCustomImageArgs =
        DomainDefaultUserSettingsJupyterLabAppSettingsCustomImageArgs(
            appImageConfigName = appImageConfigName ?: throw PulumiNullFieldException("appImageConfigName"),
            imageName = imageName ?: throw PulumiNullFieldException("imageName"),
            imageVersionNumber = imageVersionNumber,
        )
}
