@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.sagemaker.kotlin.inputs

import com.pulumi.aws.sagemaker.inputs.DomainDefaultUserSettingsJupyterServerAppSettingsArgs.builder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.applySuspend
import kotlin.String
import kotlin.Suppress
import kotlin.Unit
import kotlin.collections.List
import kotlin.jvm.JvmName

/**
 *
 * @property codeRepositories A list of Git repositories that SageMaker automatically displays to users for cloning in the JupyterServer application. see `code_repository` Block below.
 * @property defaultResourceSpec The default instance type and the Amazon Resource Name (ARN) of the SageMaker image created on the instance. see `default_resource_spec` Block below.
 * @property lifecycleConfigArns The Amazon Resource Name (ARN) of the Lifecycle Configurations.
 */
public data class DomainDefaultUserSettingsJupyterServerAppSettingsArgs(
    public val codeRepositories: Output<List<DomainDefaultUserSettingsJupyterServerAppSettingsCodeRepositoryArgs>>? = null,
    public val defaultResourceSpec: Output<DomainDefaultUserSettingsJupyterServerAppSettingsDefaultResourceSpecArgs>? = null,
    public val lifecycleConfigArns: Output<List<String>>? = null,
) :
    ConvertibleToJava<com.pulumi.aws.sagemaker.inputs.DomainDefaultUserSettingsJupyterServerAppSettingsArgs> {
    override fun toJava(): com.pulumi.aws.sagemaker.inputs.DomainDefaultUserSettingsJupyterServerAppSettingsArgs =
        com.pulumi.aws.sagemaker.inputs.DomainDefaultUserSettingsJupyterServerAppSettingsArgs.builder()
            .codeRepositories(
                codeRepositories?.applyValue({ args0 ->
                    args0.map({ args0 ->
                        args0.let({ args0 ->
                            args0.toJava()
                        })
                    })
                }),
            )
            .defaultResourceSpec(
                defaultResourceSpec?.applyValue({ args0 ->
                    args0.let({ args0 ->
                        args0.toJava()
                    })
                }),
            )
            .lifecycleConfigArns(
                lifecycleConfigArns?.applyValue({ args0 ->
                    args0.map({ args0 ->
                        args0
                    })
                }),
            ).build()
}

/**
 * Builder for [DomainDefaultUserSettingsJupyterServerAppSettingsArgs].
 */
@PulumiTagMarker
public class DomainDefaultUserSettingsJupyterServerAppSettingsArgsBuilder internal constructor() {
    private var codeRepositories:
        Output<List<DomainDefaultUserSettingsJupyterServerAppSettingsCodeRepositoryArgs>>? = null

    private var defaultResourceSpec:
        Output<DomainDefaultUserSettingsJupyterServerAppSettingsDefaultResourceSpecArgs>? = null

    private var lifecycleConfigArns: Output<List<String>>? = null

    /**
     * @param value A list of Git repositories that SageMaker automatically displays to users for cloning in the JupyterServer application. see `code_repository` Block below.
     */
    @JvmName("jmktgohopdehhoae")
    public suspend fun codeRepositories(`value`: Output<List<DomainDefaultUserSettingsJupyterServerAppSettingsCodeRepositoryArgs>>) {
        this.codeRepositories = value
    }

    @JvmName("usvdibxltrnmrmlt")
    public suspend fun codeRepositories(vararg values: Output<DomainDefaultUserSettingsJupyterServerAppSettingsCodeRepositoryArgs>) {
        this.codeRepositories = Output.all(values.asList())
    }

    /**
     * @param values A list of Git repositories that SageMaker automatically displays to users for cloning in the JupyterServer application. see `code_repository` Block below.
     */
    @JvmName("ducpuybdawhcsbxb")
    public suspend fun codeRepositories(values: List<Output<DomainDefaultUserSettingsJupyterServerAppSettingsCodeRepositoryArgs>>) {
        this.codeRepositories = Output.all(values)
    }

    /**
     * @param value The default instance type and the Amazon Resource Name (ARN) of the SageMaker image created on the instance. see `default_resource_spec` Block below.
     */
    @JvmName("dwxqwvycsrnkrtnd")
    public suspend fun defaultResourceSpec(`value`: Output<DomainDefaultUserSettingsJupyterServerAppSettingsDefaultResourceSpecArgs>) {
        this.defaultResourceSpec = value
    }

    /**
     * @param value The Amazon Resource Name (ARN) of the Lifecycle Configurations.
     */
    @JvmName("pvbdbmdosrlofcvs")
    public suspend fun lifecycleConfigArns(`value`: Output<List<String>>) {
        this.lifecycleConfigArns = value
    }

    @JvmName("qqrbwqrrowkiieoy")
    public suspend fun lifecycleConfigArns(vararg values: Output<String>) {
        this.lifecycleConfigArns = Output.all(values.asList())
    }

    /**
     * @param values The Amazon Resource Name (ARN) of the Lifecycle Configurations.
     */
    @JvmName("tiuprgorbsrjyyca")
    public suspend fun lifecycleConfigArns(values: List<Output<String>>) {
        this.lifecycleConfigArns = Output.all(values)
    }

    /**
     * @param value A list of Git repositories that SageMaker automatically displays to users for cloning in the JupyterServer application. see `code_repository` Block below.
     */
    @JvmName("jegvmpduvaectxev")
    public suspend fun codeRepositories(`value`: List<DomainDefaultUserSettingsJupyterServerAppSettingsCodeRepositoryArgs>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.codeRepositories = mapped
    }

    /**
     * @param argument A list of Git repositories that SageMaker automatically displays to users for cloning in the JupyterServer application. see `code_repository` Block below.
     */
    @JvmName("ystlbtjrhhrpekpp")
    public suspend fun codeRepositories(argument: List<suspend DomainDefaultUserSettingsJupyterServerAppSettingsCodeRepositoryArgsBuilder.() -> Unit>) {
        val toBeMapped = argument.toList().map {
            DomainDefaultUserSettingsJupyterServerAppSettingsCodeRepositoryArgsBuilder().applySuspend {
                it()
            }.build()
        }
        val mapped = of(toBeMapped)
        this.codeRepositories = mapped
    }

    /**
     * @param argument A list of Git repositories that SageMaker automatically displays to users for cloning in the JupyterServer application. see `code_repository` Block below.
     */
    @JvmName("fhvsgfiswaamhgdb")
    public suspend fun codeRepositories(vararg argument: suspend DomainDefaultUserSettingsJupyterServerAppSettingsCodeRepositoryArgsBuilder.() -> Unit) {
        val toBeMapped = argument.toList().map {
            DomainDefaultUserSettingsJupyterServerAppSettingsCodeRepositoryArgsBuilder().applySuspend {
                it()
            }.build()
        }
        val mapped = of(toBeMapped)
        this.codeRepositories = mapped
    }

    /**
     * @param argument A list of Git repositories that SageMaker automatically displays to users for cloning in the JupyterServer application. see `code_repository` Block below.
     */
    @JvmName("xhxpcokiqvvaoavn")
    public suspend fun codeRepositories(argument: suspend DomainDefaultUserSettingsJupyterServerAppSettingsCodeRepositoryArgsBuilder.() -> Unit) {
        val toBeMapped =
            listOf(
                DomainDefaultUserSettingsJupyterServerAppSettingsCodeRepositoryArgsBuilder().applySuspend
                    { argument() }.build(),
            )
        val mapped = of(toBeMapped)
        this.codeRepositories = mapped
    }

    /**
     * @param values A list of Git repositories that SageMaker automatically displays to users for cloning in the JupyterServer application. see `code_repository` Block below.
     */
    @JvmName("rprtpggvwjjqfunc")
    public suspend fun codeRepositories(vararg values: DomainDefaultUserSettingsJupyterServerAppSettingsCodeRepositoryArgs) {
        val toBeMapped = values.toList()
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.codeRepositories = mapped
    }

    /**
     * @param value The default instance type and the Amazon Resource Name (ARN) of the SageMaker image created on the instance. see `default_resource_spec` Block below.
     */
    @JvmName("avsmkssurloghisy")
    public suspend fun defaultResourceSpec(`value`: DomainDefaultUserSettingsJupyterServerAppSettingsDefaultResourceSpecArgs?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.defaultResourceSpec = mapped
    }

    /**
     * @param argument The default instance type and the Amazon Resource Name (ARN) of the SageMaker image created on the instance. see `default_resource_spec` Block below.
     */
    @JvmName("chvonpkdakjbxybj")
    public suspend fun defaultResourceSpec(argument: suspend DomainDefaultUserSettingsJupyterServerAppSettingsDefaultResourceSpecArgsBuilder.() -> Unit) {
        val toBeMapped =
            DomainDefaultUserSettingsJupyterServerAppSettingsDefaultResourceSpecArgsBuilder().applySuspend {
                argument()
            }.build()
        val mapped = of(toBeMapped)
        this.defaultResourceSpec = mapped
    }

    /**
     * @param value The Amazon Resource Name (ARN) of the Lifecycle Configurations.
     */
    @JvmName("iefkfyatohbmrdgy")
    public suspend fun lifecycleConfigArns(`value`: List<String>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.lifecycleConfigArns = mapped
    }

    /**
     * @param values The Amazon Resource Name (ARN) of the Lifecycle Configurations.
     */
    @JvmName("unbaxtvxyrqdfpqq")
    public suspend fun lifecycleConfigArns(vararg values: String) {
        val toBeMapped = values.toList()
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.lifecycleConfigArns = mapped
    }

    internal fun build(): DomainDefaultUserSettingsJupyterServerAppSettingsArgs =
        DomainDefaultUserSettingsJupyterServerAppSettingsArgs(
            codeRepositories = codeRepositories,
            defaultResourceSpec = defaultResourceSpec,
            lifecycleConfigArns = lifecycleConfigArns,
        )
}
