@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.sagemaker.kotlin.inputs

import com.pulumi.aws.sagemaker.inputs.DomainDefaultUserSettingsKernelGatewayAppSettingsArgs.builder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.applySuspend
import kotlin.String
import kotlin.Suppress
import kotlin.Unit
import kotlin.collections.List
import kotlin.jvm.JvmName

/**
 *
 * @property customImages A list of custom SageMaker images that are configured to run as a KernelGateway app. see `custom_image` Block below.
 * @property defaultResourceSpec The default instance type and the Amazon Resource Name (ARN) of the SageMaker image created on the instance. see `default_resource_spec` Block below.
 * @property lifecycleConfigArns The Amazon Resource Name (ARN) of the Lifecycle Configurations.
 */
public data class DomainDefaultUserSettingsKernelGatewayAppSettingsArgs(
    public val customImages: Output<List<DomainDefaultUserSettingsKernelGatewayAppSettingsCustomImageArgs>>? = null,
    public val defaultResourceSpec: Output<DomainDefaultUserSettingsKernelGatewayAppSettingsDefaultResourceSpecArgs>? = null,
    public val lifecycleConfigArns: Output<List<String>>? = null,
) :
    ConvertibleToJava<com.pulumi.aws.sagemaker.inputs.DomainDefaultUserSettingsKernelGatewayAppSettingsArgs> {
    override fun toJava(): com.pulumi.aws.sagemaker.inputs.DomainDefaultUserSettingsKernelGatewayAppSettingsArgs =
        com.pulumi.aws.sagemaker.inputs.DomainDefaultUserSettingsKernelGatewayAppSettingsArgs.builder()
            .customImages(
                customImages?.applyValue({ args0 ->
                    args0.map({ args0 ->
                        args0.let({ args0 ->
                            args0.toJava()
                        })
                    })
                }),
            )
            .defaultResourceSpec(
                defaultResourceSpec?.applyValue({ args0 ->
                    args0.let({ args0 ->
                        args0.toJava()
                    })
                }),
            )
            .lifecycleConfigArns(
                lifecycleConfigArns?.applyValue({ args0 ->
                    args0.map({ args0 ->
                        args0
                    })
                }),
            ).build()
}

/**
 * Builder for [DomainDefaultUserSettingsKernelGatewayAppSettingsArgs].
 */
@PulumiTagMarker
public class DomainDefaultUserSettingsKernelGatewayAppSettingsArgsBuilder internal constructor() {
    private var customImages:
        Output<List<DomainDefaultUserSettingsKernelGatewayAppSettingsCustomImageArgs>>? = null

    private var defaultResourceSpec:
        Output<DomainDefaultUserSettingsKernelGatewayAppSettingsDefaultResourceSpecArgs>? = null

    private var lifecycleConfigArns: Output<List<String>>? = null

    /**
     * @param value A list of custom SageMaker images that are configured to run as a KernelGateway app. see `custom_image` Block below.
     */
    @JvmName("pksjtrqwbokruejy")
    public suspend fun customImages(`value`: Output<List<DomainDefaultUserSettingsKernelGatewayAppSettingsCustomImageArgs>>) {
        this.customImages = value
    }

    @JvmName("sjvmaavqwiufctne")
    public suspend fun customImages(vararg values: Output<DomainDefaultUserSettingsKernelGatewayAppSettingsCustomImageArgs>) {
        this.customImages = Output.all(values.asList())
    }

    /**
     * @param values A list of custom SageMaker images that are configured to run as a KernelGateway app. see `custom_image` Block below.
     */
    @JvmName("fjntkbiyveomsgil")
    public suspend fun customImages(values: List<Output<DomainDefaultUserSettingsKernelGatewayAppSettingsCustomImageArgs>>) {
        this.customImages = Output.all(values)
    }

    /**
     * @param value The default instance type and the Amazon Resource Name (ARN) of the SageMaker image created on the instance. see `default_resource_spec` Block below.
     */
    @JvmName("yrhxybcbunlwkkxq")
    public suspend fun defaultResourceSpec(`value`: Output<DomainDefaultUserSettingsKernelGatewayAppSettingsDefaultResourceSpecArgs>) {
        this.defaultResourceSpec = value
    }

    /**
     * @param value The Amazon Resource Name (ARN) of the Lifecycle Configurations.
     */
    @JvmName("ylkdvbbkbmqtfroi")
    public suspend fun lifecycleConfigArns(`value`: Output<List<String>>) {
        this.lifecycleConfigArns = value
    }

    @JvmName("igstvlmjwqkiyjrq")
    public suspend fun lifecycleConfigArns(vararg values: Output<String>) {
        this.lifecycleConfigArns = Output.all(values.asList())
    }

    /**
     * @param values The Amazon Resource Name (ARN) of the Lifecycle Configurations.
     */
    @JvmName("jliahjxivcahxrhu")
    public suspend fun lifecycleConfigArns(values: List<Output<String>>) {
        this.lifecycleConfigArns = Output.all(values)
    }

    /**
     * @param value A list of custom SageMaker images that are configured to run as a KernelGateway app. see `custom_image` Block below.
     */
    @JvmName("xvedwfixfgxybfec")
    public suspend fun customImages(`value`: List<DomainDefaultUserSettingsKernelGatewayAppSettingsCustomImageArgs>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.customImages = mapped
    }

    /**
     * @param argument A list of custom SageMaker images that are configured to run as a KernelGateway app. see `custom_image` Block below.
     */
    @JvmName("snwtgawvcfrsauur")
    public suspend fun customImages(argument: List<suspend DomainDefaultUserSettingsKernelGatewayAppSettingsCustomImageArgsBuilder.() -> Unit>) {
        val toBeMapped = argument.toList().map {
            DomainDefaultUserSettingsKernelGatewayAppSettingsCustomImageArgsBuilder().applySuspend {
                it()
            }.build()
        }
        val mapped = of(toBeMapped)
        this.customImages = mapped
    }

    /**
     * @param argument A list of custom SageMaker images that are configured to run as a KernelGateway app. see `custom_image` Block below.
     */
    @JvmName("lgisxnwdpysuqksf")
    public suspend fun customImages(vararg argument: suspend DomainDefaultUserSettingsKernelGatewayAppSettingsCustomImageArgsBuilder.() -> Unit) {
        val toBeMapped = argument.toList().map {
            DomainDefaultUserSettingsKernelGatewayAppSettingsCustomImageArgsBuilder().applySuspend {
                it()
            }.build()
        }
        val mapped = of(toBeMapped)
        this.customImages = mapped
    }

    /**
     * @param argument A list of custom SageMaker images that are configured to run as a KernelGateway app. see `custom_image` Block below.
     */
    @JvmName("uaqofrpocbbcbsuv")
    public suspend fun customImages(argument: suspend DomainDefaultUserSettingsKernelGatewayAppSettingsCustomImageArgsBuilder.() -> Unit) {
        val toBeMapped =
            listOf(
                DomainDefaultUserSettingsKernelGatewayAppSettingsCustomImageArgsBuilder().applySuspend
                    { argument() }.build(),
            )
        val mapped = of(toBeMapped)
        this.customImages = mapped
    }

    /**
     * @param values A list of custom SageMaker images that are configured to run as a KernelGateway app. see `custom_image` Block below.
     */
    @JvmName("fggskefbfqoxrknl")
    public suspend fun customImages(vararg values: DomainDefaultUserSettingsKernelGatewayAppSettingsCustomImageArgs) {
        val toBeMapped = values.toList()
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.customImages = mapped
    }

    /**
     * @param value The default instance type and the Amazon Resource Name (ARN) of the SageMaker image created on the instance. see `default_resource_spec` Block below.
     */
    @JvmName("dxreghdolnnhahau")
    public suspend fun defaultResourceSpec(`value`: DomainDefaultUserSettingsKernelGatewayAppSettingsDefaultResourceSpecArgs?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.defaultResourceSpec = mapped
    }

    /**
     * @param argument The default instance type and the Amazon Resource Name (ARN) of the SageMaker image created on the instance. see `default_resource_spec` Block below.
     */
    @JvmName("yhoppucsthpilrwf")
    public suspend fun defaultResourceSpec(argument: suspend DomainDefaultUserSettingsKernelGatewayAppSettingsDefaultResourceSpecArgsBuilder.() -> Unit) {
        val toBeMapped =
            DomainDefaultUserSettingsKernelGatewayAppSettingsDefaultResourceSpecArgsBuilder().applySuspend {
                argument()
            }.build()
        val mapped = of(toBeMapped)
        this.defaultResourceSpec = mapped
    }

    /**
     * @param value The Amazon Resource Name (ARN) of the Lifecycle Configurations.
     */
    @JvmName("rquyxhmhdsidmapu")
    public suspend fun lifecycleConfigArns(`value`: List<String>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.lifecycleConfigArns = mapped
    }

    /**
     * @param values The Amazon Resource Name (ARN) of the Lifecycle Configurations.
     */
    @JvmName("ddqalvhqxfmhlrnw")
    public suspend fun lifecycleConfigArns(vararg values: String) {
        val toBeMapped = values.toList()
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.lifecycleConfigArns = mapped
    }

    internal fun build(): DomainDefaultUserSettingsKernelGatewayAppSettingsArgs =
        DomainDefaultUserSettingsKernelGatewayAppSettingsArgs(
            customImages = customImages,
            defaultResourceSpec = defaultResourceSpec,
            lifecycleConfigArns = lifecycleConfigArns,
        )
}
