@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.sagemaker.kotlin.inputs

import com.pulumi.aws.sagemaker.inputs.DomainDefaultUserSettingsRSessionAppSettingsArgs.builder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.applySuspend
import kotlin.Suppress
import kotlin.Unit
import kotlin.collections.List
import kotlin.jvm.JvmName

/**
 *
 * @property customImages A list of custom SageMaker images that are configured to run as a RSession app. see `custom_image` Block below.
 * @property defaultResourceSpec The default instance type and the Amazon Resource Name (ARN) of the SageMaker image created on the instance. see `default_resource_spec` Block above.
 */
public data class DomainDefaultUserSettingsRSessionAppSettingsArgs(
    public val customImages: Output<List<DomainDefaultUserSettingsRSessionAppSettingsCustomImageArgs>>? = null,
    public val defaultResourceSpec: Output<DomainDefaultUserSettingsRSessionAppSettingsDefaultResourceSpecArgs>? = null,
) :
    ConvertibleToJava<com.pulumi.aws.sagemaker.inputs.DomainDefaultUserSettingsRSessionAppSettingsArgs> {
    override fun toJava(): com.pulumi.aws.sagemaker.inputs.DomainDefaultUserSettingsRSessionAppSettingsArgs =
        com.pulumi.aws.sagemaker.inputs.DomainDefaultUserSettingsRSessionAppSettingsArgs.builder()
            .customImages(
                customImages?.applyValue({ args0 ->
                    args0.map({ args0 ->
                        args0.let({ args0 ->
                            args0.toJava()
                        })
                    })
                }),
            )
            .defaultResourceSpec(
                defaultResourceSpec?.applyValue({ args0 ->
                    args0.let({ args0 ->
                        args0.toJava()
                    })
                }),
            ).build()
}

/**
 * Builder for [DomainDefaultUserSettingsRSessionAppSettingsArgs].
 */
@PulumiTagMarker
public class DomainDefaultUserSettingsRSessionAppSettingsArgsBuilder internal constructor() {
    private var customImages:
        Output<List<DomainDefaultUserSettingsRSessionAppSettingsCustomImageArgs>>? = null

    private var defaultResourceSpec:
        Output<DomainDefaultUserSettingsRSessionAppSettingsDefaultResourceSpecArgs>? = null

    /**
     * @param value A list of custom SageMaker images that are configured to run as a RSession app. see `custom_image` Block below.
     */
    @JvmName("gsccqmleywtdhjtw")
    public suspend fun customImages(`value`: Output<List<DomainDefaultUserSettingsRSessionAppSettingsCustomImageArgs>>) {
        this.customImages = value
    }

    @JvmName("cahwlpntxwjeqllu")
    public suspend fun customImages(vararg values: Output<DomainDefaultUserSettingsRSessionAppSettingsCustomImageArgs>) {
        this.customImages = Output.all(values.asList())
    }

    /**
     * @param values A list of custom SageMaker images that are configured to run as a RSession app. see `custom_image` Block below.
     */
    @JvmName("vcumsjfficqdvyee")
    public suspend fun customImages(values: List<Output<DomainDefaultUserSettingsRSessionAppSettingsCustomImageArgs>>) {
        this.customImages = Output.all(values)
    }

    /**
     * @param value The default instance type and the Amazon Resource Name (ARN) of the SageMaker image created on the instance. see `default_resource_spec` Block above.
     */
    @JvmName("csctnqhnqrjpbutl")
    public suspend fun defaultResourceSpec(`value`: Output<DomainDefaultUserSettingsRSessionAppSettingsDefaultResourceSpecArgs>) {
        this.defaultResourceSpec = value
    }

    /**
     * @param value A list of custom SageMaker images that are configured to run as a RSession app. see `custom_image` Block below.
     */
    @JvmName("cmlgevnndyjwoyyy")
    public suspend fun customImages(`value`: List<DomainDefaultUserSettingsRSessionAppSettingsCustomImageArgs>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.customImages = mapped
    }

    /**
     * @param argument A list of custom SageMaker images that are configured to run as a RSession app. see `custom_image` Block below.
     */
    @JvmName("lyangidjaxiwbupe")
    public suspend fun customImages(argument: List<suspend DomainDefaultUserSettingsRSessionAppSettingsCustomImageArgsBuilder.() -> Unit>) {
        val toBeMapped = argument.toList().map {
            DomainDefaultUserSettingsRSessionAppSettingsCustomImageArgsBuilder().applySuspend {
                it()
            }.build()
        }
        val mapped = of(toBeMapped)
        this.customImages = mapped
    }

    /**
     * @param argument A list of custom SageMaker images that are configured to run as a RSession app. see `custom_image` Block below.
     */
    @JvmName("yqeliikkisjgcbfd")
    public suspend fun customImages(vararg argument: suspend DomainDefaultUserSettingsRSessionAppSettingsCustomImageArgsBuilder.() -> Unit) {
        val toBeMapped = argument.toList().map {
            DomainDefaultUserSettingsRSessionAppSettingsCustomImageArgsBuilder().applySuspend {
                it()
            }.build()
        }
        val mapped = of(toBeMapped)
        this.customImages = mapped
    }

    /**
     * @param argument A list of custom SageMaker images that are configured to run as a RSession app. see `custom_image` Block below.
     */
    @JvmName("cdbjmfliyyqkqqxq")
    public suspend fun customImages(argument: suspend DomainDefaultUserSettingsRSessionAppSettingsCustomImageArgsBuilder.() -> Unit) {
        val toBeMapped =
            listOf(
                DomainDefaultUserSettingsRSessionAppSettingsCustomImageArgsBuilder().applySuspend {
                    argument()
                }.build(),
            )
        val mapped = of(toBeMapped)
        this.customImages = mapped
    }

    /**
     * @param values A list of custom SageMaker images that are configured to run as a RSession app. see `custom_image` Block below.
     */
    @JvmName("obggeyshoteieevf")
    public suspend fun customImages(vararg values: DomainDefaultUserSettingsRSessionAppSettingsCustomImageArgs) {
        val toBeMapped = values.toList()
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.customImages = mapped
    }

    /**
     * @param value The default instance type and the Amazon Resource Name (ARN) of the SageMaker image created on the instance. see `default_resource_spec` Block above.
     */
    @JvmName("ymhnjedkvwhgwblx")
    public suspend fun defaultResourceSpec(`value`: DomainDefaultUserSettingsRSessionAppSettingsDefaultResourceSpecArgs?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.defaultResourceSpec = mapped
    }

    /**
     * @param argument The default instance type and the Amazon Resource Name (ARN) of the SageMaker image created on the instance. see `default_resource_spec` Block above.
     */
    @JvmName("htaeqibtpvtdtxsr")
    public suspend fun defaultResourceSpec(argument: suspend DomainDefaultUserSettingsRSessionAppSettingsDefaultResourceSpecArgsBuilder.() -> Unit) {
        val toBeMapped =
            DomainDefaultUserSettingsRSessionAppSettingsDefaultResourceSpecArgsBuilder().applySuspend {
                argument()
            }.build()
        val mapped = of(toBeMapped)
        this.defaultResourceSpec = mapped
    }

    internal fun build(): DomainDefaultUserSettingsRSessionAppSettingsArgs =
        DomainDefaultUserSettingsRSessionAppSettingsArgs(
            customImages = customImages,
            defaultResourceSpec = defaultResourceSpec,
        )
}
