@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.sagemaker.kotlin.inputs

import com.pulumi.aws.sagemaker.inputs.DomainDefaultUserSettingsRStudioServerProAppSettingsArgs.builder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.String
import kotlin.Suppress
import kotlin.jvm.JvmName

/**
 *
 * @property accessStatus Indicates whether the current user has access to the RStudioServerPro app. Valid values are `ENABLED` and `DISABLED`.
 * @property userGroup The level of permissions that the user has within the RStudioServerPro app. This value defaults to `R_STUDIO_USER`. The `R_STUDIO_ADMIN` value allows the user access to the RStudio Administrative Dashboard. Valid values are `R_STUDIO_USER` and `R_STUDIO_ADMIN`.
 */
public data class DomainDefaultUserSettingsRStudioServerProAppSettingsArgs(
    public val accessStatus: Output<String>? = null,
    public val userGroup: Output<String>? = null,
) :
    ConvertibleToJava<com.pulumi.aws.sagemaker.inputs.DomainDefaultUserSettingsRStudioServerProAppSettingsArgs> {
    override fun toJava(): com.pulumi.aws.sagemaker.inputs.DomainDefaultUserSettingsRStudioServerProAppSettingsArgs =
        com.pulumi.aws.sagemaker.inputs.DomainDefaultUserSettingsRStudioServerProAppSettingsArgs.builder()
            .accessStatus(accessStatus?.applyValue({ args0 -> args0 }))
            .userGroup(userGroup?.applyValue({ args0 -> args0 })).build()
}

/**
 * Builder for [DomainDefaultUserSettingsRStudioServerProAppSettingsArgs].
 */
@PulumiTagMarker
public class DomainDefaultUserSettingsRStudioServerProAppSettingsArgsBuilder internal constructor() {
    private var accessStatus: Output<String>? = null

    private var userGroup: Output<String>? = null

    /**
     * @param value Indicates whether the current user has access to the RStudioServerPro app. Valid values are `ENABLED` and `DISABLED`.
     */
    @JvmName("uxyjcdnfjlseimbn")
    public suspend fun accessStatus(`value`: Output<String>) {
        this.accessStatus = value
    }

    /**
     * @param value The level of permissions that the user has within the RStudioServerPro app. This value defaults to `R_STUDIO_USER`. The `R_STUDIO_ADMIN` value allows the user access to the RStudio Administrative Dashboard. Valid values are `R_STUDIO_USER` and `R_STUDIO_ADMIN`.
     */
    @JvmName("jphnelsvptqeakdn")
    public suspend fun userGroup(`value`: Output<String>) {
        this.userGroup = value
    }

    /**
     * @param value Indicates whether the current user has access to the RStudioServerPro app. Valid values are `ENABLED` and `DISABLED`.
     */
    @JvmName("glxammqurfjfjbti")
    public suspend fun accessStatus(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.accessStatus = mapped
    }

    /**
     * @param value The level of permissions that the user has within the RStudioServerPro app. This value defaults to `R_STUDIO_USER`. The `R_STUDIO_ADMIN` value allows the user access to the RStudio Administrative Dashboard. Valid values are `R_STUDIO_USER` and `R_STUDIO_ADMIN`.
     */
    @JvmName("shlqsqfpyeggmglp")
    public suspend fun userGroup(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.userGroup = mapped
    }

    internal fun build(): DomainDefaultUserSettingsRStudioServerProAppSettingsArgs =
        DomainDefaultUserSettingsRStudioServerProAppSettingsArgs(
            accessStatus = accessStatus,
            userGroup = userGroup,
        )
}
