@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.sagemaker.kotlin.inputs

import com.pulumi.aws.sagemaker.inputs.DomainDefaultUserSettingsSpaceStorageSettingsArgs.builder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.applySuspend
import kotlin.Suppress
import kotlin.Unit
import kotlin.jvm.JvmName

/**
 *
 * @property defaultEbsStorageSettings The default EBS storage settings for a private space. See `default_ebs_storage_settings` Block below.
 */
public data class DomainDefaultUserSettingsSpaceStorageSettingsArgs(
    public val defaultEbsStorageSettings: Output<DomainDefaultUserSettingsSpaceStorageSettingsDefaultEbsStorageSettingsArgs>? = null,
) :
    ConvertibleToJava<com.pulumi.aws.sagemaker.inputs.DomainDefaultUserSettingsSpaceStorageSettingsArgs> {
    override fun toJava(): com.pulumi.aws.sagemaker.inputs.DomainDefaultUserSettingsSpaceStorageSettingsArgs =
        com.pulumi.aws.sagemaker.inputs.DomainDefaultUserSettingsSpaceStorageSettingsArgs.builder()
            .defaultEbsStorageSettings(
                defaultEbsStorageSettings?.applyValue({ args0 ->
                    args0.let({ args0 ->
                        args0.toJava()
                    })
                }),
            ).build()
}

/**
 * Builder for [DomainDefaultUserSettingsSpaceStorageSettingsArgs].
 */
@PulumiTagMarker
public class DomainDefaultUserSettingsSpaceStorageSettingsArgsBuilder internal constructor() {
    private var defaultEbsStorageSettings:
        Output<DomainDefaultUserSettingsSpaceStorageSettingsDefaultEbsStorageSettingsArgs>? = null

    /**
     * @param value The default EBS storage settings for a private space. See `default_ebs_storage_settings` Block below.
     */
    @JvmName("rwtpalphlujkgnul")
    public suspend fun defaultEbsStorageSettings(`value`: Output<DomainDefaultUserSettingsSpaceStorageSettingsDefaultEbsStorageSettingsArgs>) {
        this.defaultEbsStorageSettings = value
    }

    /**
     * @param value The default EBS storage settings for a private space. See `default_ebs_storage_settings` Block below.
     */
    @JvmName("setemvavscyfhgof")
    public suspend fun defaultEbsStorageSettings(`value`: DomainDefaultUserSettingsSpaceStorageSettingsDefaultEbsStorageSettingsArgs?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.defaultEbsStorageSettings = mapped
    }

    /**
     * @param argument The default EBS storage settings for a private space. See `default_ebs_storage_settings` Block below.
     */
    @JvmName("lxyufwkosavfutun")
    public suspend fun defaultEbsStorageSettings(argument: suspend DomainDefaultUserSettingsSpaceStorageSettingsDefaultEbsStorageSettingsArgsBuilder.() -> Unit) {
        val toBeMapped =
            DomainDefaultUserSettingsSpaceStorageSettingsDefaultEbsStorageSettingsArgsBuilder().applySuspend {
                argument()
            }.build()
        val mapped = of(toBeMapped)
        this.defaultEbsStorageSettings = mapped
    }

    internal fun build(): DomainDefaultUserSettingsSpaceStorageSettingsArgs =
        DomainDefaultUserSettingsSpaceStorageSettingsArgs(
            defaultEbsStorageSettings = defaultEbsStorageSettings,
        )
}
