@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.sagemaker.kotlin.inputs

import com.pulumi.aws.sagemaker.inputs.DomainDefaultUserSettingsTensorBoardAppSettingsArgs.builder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.applySuspend
import kotlin.Suppress
import kotlin.Unit
import kotlin.jvm.JvmName

/**
 *
 * @property defaultResourceSpec The default instance type and the Amazon Resource Name (ARN) of the SageMaker image created on the instance. see `default_resource_spec` Block below.
 */
public data class DomainDefaultUserSettingsTensorBoardAppSettingsArgs(
    public val defaultResourceSpec: Output<DomainDefaultUserSettingsTensorBoardAppSettingsDefaultResourceSpecArgs>? = null,
) :
    ConvertibleToJava<com.pulumi.aws.sagemaker.inputs.DomainDefaultUserSettingsTensorBoardAppSettingsArgs> {
    override fun toJava(): com.pulumi.aws.sagemaker.inputs.DomainDefaultUserSettingsTensorBoardAppSettingsArgs =
        com.pulumi.aws.sagemaker.inputs.DomainDefaultUserSettingsTensorBoardAppSettingsArgs.builder()
            .defaultResourceSpec(
                defaultResourceSpec?.applyValue({ args0 ->
                    args0.let({ args0 ->
                        args0.toJava()
                    })
                }),
            ).build()
}

/**
 * Builder for [DomainDefaultUserSettingsTensorBoardAppSettingsArgs].
 */
@PulumiTagMarker
public class DomainDefaultUserSettingsTensorBoardAppSettingsArgsBuilder internal constructor() {
    private var defaultResourceSpec:
        Output<DomainDefaultUserSettingsTensorBoardAppSettingsDefaultResourceSpecArgs>? = null

    /**
     * @param value The default instance type and the Amazon Resource Name (ARN) of the SageMaker image created on the instance. see `default_resource_spec` Block below.
     */
    @JvmName("jiovtdvloxxgnhxg")
    public suspend fun defaultResourceSpec(`value`: Output<DomainDefaultUserSettingsTensorBoardAppSettingsDefaultResourceSpecArgs>) {
        this.defaultResourceSpec = value
    }

    /**
     * @param value The default instance type and the Amazon Resource Name (ARN) of the SageMaker image created on the instance. see `default_resource_spec` Block below.
     */
    @JvmName("xmjpgepqwvyhxjuv")
    public suspend fun defaultResourceSpec(`value`: DomainDefaultUserSettingsTensorBoardAppSettingsDefaultResourceSpecArgs?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.defaultResourceSpec = mapped
    }

    /**
     * @param argument The default instance type and the Amazon Resource Name (ARN) of the SageMaker image created on the instance. see `default_resource_spec` Block below.
     */
    @JvmName("gcnkviykpqrvthul")
    public suspend fun defaultResourceSpec(argument: suspend DomainDefaultUserSettingsTensorBoardAppSettingsDefaultResourceSpecArgsBuilder.() -> Unit) {
        val toBeMapped =
            DomainDefaultUserSettingsTensorBoardAppSettingsDefaultResourceSpecArgsBuilder().applySuspend {
                argument()
            }.build()
        val mapped = of(toBeMapped)
        this.defaultResourceSpec = mapped
    }

    internal fun build(): DomainDefaultUserSettingsTensorBoardAppSettingsArgs =
        DomainDefaultUserSettingsTensorBoardAppSettingsArgs(
            defaultResourceSpec = defaultResourceSpec,
        )
}
