@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.sagemaker.kotlin.inputs

import com.pulumi.aws.sagemaker.inputs.DomainDomainSettingsArgs.builder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.applySuspend
import kotlin.String
import kotlin.Suppress
import kotlin.Unit
import kotlin.collections.List
import kotlin.jvm.JvmName

/**
 *
 * @property executionRoleIdentityConfig The configuration for attaching a SageMaker user profile name to the execution role as a sts:SourceIdentity key [AWS Docs](https://docs.aws.amazon.com/IAM/latest/UserGuide/id_credentials_temp_control-access_monitor.html). Valid values are `USER_PROFILE_NAME` and `DISABLED`.
 * @property rStudioServerProDomainSettings A collection of settings that configure the RStudioServerPro Domain-level app. see `r_studio_server_pro_domain_settings` Block below.
 * @property securityGroupIds The security groups for the Amazon Virtual Private Cloud that the Domain uses for communication between Domain-level apps and user apps.
 */
public data class DomainDomainSettingsArgs(
    public val executionRoleIdentityConfig: Output<String>? = null,
    public val rStudioServerProDomainSettings: Output<DomainDomainSettingsRStudioServerProDomainSettingsArgs>? = null,
    public val securityGroupIds: Output<List<String>>? = null,
) : ConvertibleToJava<com.pulumi.aws.sagemaker.inputs.DomainDomainSettingsArgs> {
    override fun toJava(): com.pulumi.aws.sagemaker.inputs.DomainDomainSettingsArgs =
        com.pulumi.aws.sagemaker.inputs.DomainDomainSettingsArgs.builder()
            .executionRoleIdentityConfig(executionRoleIdentityConfig?.applyValue({ args0 -> args0 }))
            .rStudioServerProDomainSettings(
                rStudioServerProDomainSettings?.applyValue({ args0 ->
                    args0.let({ args0 -> args0.toJava() })
                }),
            )
            .securityGroupIds(securityGroupIds?.applyValue({ args0 -> args0.map({ args0 -> args0 }) })).build()
}

/**
 * Builder for [DomainDomainSettingsArgs].
 */
@PulumiTagMarker
public class DomainDomainSettingsArgsBuilder internal constructor() {
    private var executionRoleIdentityConfig: Output<String>? = null

    private var rStudioServerProDomainSettings:
        Output<DomainDomainSettingsRStudioServerProDomainSettingsArgs>? = null

    private var securityGroupIds: Output<List<String>>? = null

    /**
     * @param value The configuration for attaching a SageMaker user profile name to the execution role as a sts:SourceIdentity key [AWS Docs](https://docs.aws.amazon.com/IAM/latest/UserGuide/id_credentials_temp_control-access_monitor.html). Valid values are `USER_PROFILE_NAME` and `DISABLED`.
     */
    @JvmName("lehhxecsveigkejq")
    public suspend fun executionRoleIdentityConfig(`value`: Output<String>) {
        this.executionRoleIdentityConfig = value
    }

    /**
     * @param value A collection of settings that configure the RStudioServerPro Domain-level app. see `r_studio_server_pro_domain_settings` Block below.
     */
    @JvmName("xvwvjrsschjctjxl")
    public suspend fun rStudioServerProDomainSettings(`value`: Output<DomainDomainSettingsRStudioServerProDomainSettingsArgs>) {
        this.rStudioServerProDomainSettings = value
    }

    /**
     * @param value The security groups for the Amazon Virtual Private Cloud that the Domain uses for communication between Domain-level apps and user apps.
     */
    @JvmName("yukiohvxwllvweux")
    public suspend fun securityGroupIds(`value`: Output<List<String>>) {
        this.securityGroupIds = value
    }

    @JvmName("kxgbsjognlacywec")
    public suspend fun securityGroupIds(vararg values: Output<String>) {
        this.securityGroupIds = Output.all(values.asList())
    }

    /**
     * @param values The security groups for the Amazon Virtual Private Cloud that the Domain uses for communication between Domain-level apps and user apps.
     */
    @JvmName("bvnsgqkhcvlfkrqy")
    public suspend fun securityGroupIds(values: List<Output<String>>) {
        this.securityGroupIds = Output.all(values)
    }

    /**
     * @param value The configuration for attaching a SageMaker user profile name to the execution role as a sts:SourceIdentity key [AWS Docs](https://docs.aws.amazon.com/IAM/latest/UserGuide/id_credentials_temp_control-access_monitor.html). Valid values are `USER_PROFILE_NAME` and `DISABLED`.
     */
    @JvmName("piuibypfbpkqhlqe")
    public suspend fun executionRoleIdentityConfig(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.executionRoleIdentityConfig = mapped
    }

    /**
     * @param value A collection of settings that configure the RStudioServerPro Domain-level app. see `r_studio_server_pro_domain_settings` Block below.
     */
    @JvmName("flspmwxgmbpohtrr")
    public suspend fun rStudioServerProDomainSettings(`value`: DomainDomainSettingsRStudioServerProDomainSettingsArgs?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.rStudioServerProDomainSettings = mapped
    }

    /**
     * @param argument A collection of settings that configure the RStudioServerPro Domain-level app. see `r_studio_server_pro_domain_settings` Block below.
     */
    @JvmName("mmvcxeaqyqpqjhfd")
    public suspend fun rStudioServerProDomainSettings(argument: suspend DomainDomainSettingsRStudioServerProDomainSettingsArgsBuilder.() -> Unit) {
        val toBeMapped = DomainDomainSettingsRStudioServerProDomainSettingsArgsBuilder().applySuspend {
            argument()
        }.build()
        val mapped = of(toBeMapped)
        this.rStudioServerProDomainSettings = mapped
    }

    /**
     * @param value The security groups for the Amazon Virtual Private Cloud that the Domain uses for communication between Domain-level apps and user apps.
     */
    @JvmName("pedxxfmfytchecko")
    public suspend fun securityGroupIds(`value`: List<String>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.securityGroupIds = mapped
    }

    /**
     * @param values The security groups for the Amazon Virtual Private Cloud that the Domain uses for communication between Domain-level apps and user apps.
     */
    @JvmName("mmegkkapxckyyfsn")
    public suspend fun securityGroupIds(vararg values: String) {
        val toBeMapped = values.toList()
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.securityGroupIds = mapped
    }

    internal fun build(): DomainDomainSettingsArgs = DomainDomainSettingsArgs(
        executionRoleIdentityConfig = executionRoleIdentityConfig,
        rStudioServerProDomainSettings = rStudioServerProDomainSettings,
        securityGroupIds = securityGroupIds,
    )
}
