@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.sagemaker.kotlin.inputs

import com.pulumi.aws.sagemaker.inputs.EndpointConfigurationAsyncInferenceConfigClientConfigArgs.builder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.Int
import kotlin.Suppress
import kotlin.jvm.JvmName

/**
 *
 * @property maxConcurrentInvocationsPerInstance The maximum number of concurrent requests sent by the SageMaker client to the model container. If no value is provided, Amazon SageMaker will choose an optimal value for you.
 */
public data class EndpointConfigurationAsyncInferenceConfigClientConfigArgs(
    public val maxConcurrentInvocationsPerInstance: Output<Int>? = null,
) :
    ConvertibleToJava<com.pulumi.aws.sagemaker.inputs.EndpointConfigurationAsyncInferenceConfigClientConfigArgs> {
    override fun toJava(): com.pulumi.aws.sagemaker.inputs.EndpointConfigurationAsyncInferenceConfigClientConfigArgs =
        com.pulumi.aws.sagemaker.inputs.EndpointConfigurationAsyncInferenceConfigClientConfigArgs.builder()
            .maxConcurrentInvocationsPerInstance(
                maxConcurrentInvocationsPerInstance?.applyValue({ args0 ->
                    args0
                }),
            ).build()
}

/**
 * Builder for [EndpointConfigurationAsyncInferenceConfigClientConfigArgs].
 */
@PulumiTagMarker
public class EndpointConfigurationAsyncInferenceConfigClientConfigArgsBuilder internal constructor() {
    private var maxConcurrentInvocationsPerInstance: Output<Int>? = null

    /**
     * @param value The maximum number of concurrent requests sent by the SageMaker client to the model container. If no value is provided, Amazon SageMaker will choose an optimal value for you.
     */
    @JvmName("vodvsfsvhyjcnneo")
    public suspend fun maxConcurrentInvocationsPerInstance(`value`: Output<Int>) {
        this.maxConcurrentInvocationsPerInstance = value
    }

    /**
     * @param value The maximum number of concurrent requests sent by the SageMaker client to the model container. If no value is provided, Amazon SageMaker will choose an optimal value for you.
     */
    @JvmName("lniqscicaicqkvjn")
    public suspend fun maxConcurrentInvocationsPerInstance(`value`: Int?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.maxConcurrentInvocationsPerInstance = mapped
    }

    internal fun build(): EndpointConfigurationAsyncInferenceConfigClientConfigArgs =
        EndpointConfigurationAsyncInferenceConfigClientConfigArgs(
            maxConcurrentInvocationsPerInstance = maxConcurrentInvocationsPerInstance,
        )
}
