@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.sagemaker.kotlin.inputs

import com.pulumi.aws.sagemaker.inputs.EndpointConfigurationAsyncInferenceConfigOutputConfigArgs.builder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiNullFieldException
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.applySuspend
import kotlin.String
import kotlin.Suppress
import kotlin.Unit
import kotlin.jvm.JvmName

/**
 *
 * @property kmsKeyId The Amazon Web Services Key Management Service (Amazon Web Services KMS) key that Amazon SageMaker uses to encrypt the asynchronous inference output in Amazon S3.
 * @property notificationConfig Specifies the configuration for notifications of inference results for asynchronous inference.
 * @property s3FailurePath The Amazon S3 location to upload failure inference responses to.
 * @property s3OutputPath The Amazon S3 location to upload inference responses to.
 */
public data class EndpointConfigurationAsyncInferenceConfigOutputConfigArgs(
    public val kmsKeyId: Output<String>? = null,
    public val notificationConfig: Output<EndpointConfigurationAsyncInferenceConfigOutputConfigNotificationConfigArgs>? = null,
    public val s3FailurePath: Output<String>? = null,
    public val s3OutputPath: Output<String>,
) :
    ConvertibleToJava<com.pulumi.aws.sagemaker.inputs.EndpointConfigurationAsyncInferenceConfigOutputConfigArgs> {
    override fun toJava(): com.pulumi.aws.sagemaker.inputs.EndpointConfigurationAsyncInferenceConfigOutputConfigArgs =
        com.pulumi.aws.sagemaker.inputs.EndpointConfigurationAsyncInferenceConfigOutputConfigArgs.builder()
            .kmsKeyId(kmsKeyId?.applyValue({ args0 -> args0 }))
            .notificationConfig(
                notificationConfig?.applyValue({ args0 ->
                    args0.let({ args0 ->
                        args0.toJava()
                    })
                }),
            )
            .s3FailurePath(s3FailurePath?.applyValue({ args0 -> args0 }))
            .s3OutputPath(s3OutputPath.applyValue({ args0 -> args0 })).build()
}

/**
 * Builder for [EndpointConfigurationAsyncInferenceConfigOutputConfigArgs].
 */
@PulumiTagMarker
public class EndpointConfigurationAsyncInferenceConfigOutputConfigArgsBuilder internal constructor() {
    private var kmsKeyId: Output<String>? = null

    private var notificationConfig:
        Output<EndpointConfigurationAsyncInferenceConfigOutputConfigNotificationConfigArgs>? = null

    private var s3FailurePath: Output<String>? = null

    private var s3OutputPath: Output<String>? = null

    /**
     * @param value The Amazon Web Services Key Management Service (Amazon Web Services KMS) key that Amazon SageMaker uses to encrypt the asynchronous inference output in Amazon S3.
     */
    @JvmName("cjrqbpdpvyapyctm")
    public suspend fun kmsKeyId(`value`: Output<String>) {
        this.kmsKeyId = value
    }

    /**
     * @param value Specifies the configuration for notifications of inference results for asynchronous inference.
     */
    @JvmName("exikvggplmyotpvd")
    public suspend fun notificationConfig(`value`: Output<EndpointConfigurationAsyncInferenceConfigOutputConfigNotificationConfigArgs>) {
        this.notificationConfig = value
    }

    /**
     * @param value The Amazon S3 location to upload failure inference responses to.
     */
    @JvmName("dwigpkppeendlmcr")
    public suspend fun s3FailurePath(`value`: Output<String>) {
        this.s3FailurePath = value
    }

    /**
     * @param value The Amazon S3 location to upload inference responses to.
     */
    @JvmName("khsiyarwytjplgmp")
    public suspend fun s3OutputPath(`value`: Output<String>) {
        this.s3OutputPath = value
    }

    /**
     * @param value The Amazon Web Services Key Management Service (Amazon Web Services KMS) key that Amazon SageMaker uses to encrypt the asynchronous inference output in Amazon S3.
     */
    @JvmName("xnkvihtekacbudwm")
    public suspend fun kmsKeyId(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.kmsKeyId = mapped
    }

    /**
     * @param value Specifies the configuration for notifications of inference results for asynchronous inference.
     */
    @JvmName("grrfumgsqlsfsqwi")
    public suspend fun notificationConfig(`value`: EndpointConfigurationAsyncInferenceConfigOutputConfigNotificationConfigArgs?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.notificationConfig = mapped
    }

    /**
     * @param argument Specifies the configuration for notifications of inference results for asynchronous inference.
     */
    @JvmName("dilijtqhyjrbgdfq")
    public suspend fun notificationConfig(argument: suspend EndpointConfigurationAsyncInferenceConfigOutputConfigNotificationConfigArgsBuilder.() -> Unit) {
        val toBeMapped =
            EndpointConfigurationAsyncInferenceConfigOutputConfigNotificationConfigArgsBuilder().applySuspend {
                argument()
            }.build()
        val mapped = of(toBeMapped)
        this.notificationConfig = mapped
    }

    /**
     * @param value The Amazon S3 location to upload failure inference responses to.
     */
    @JvmName("xhnxgdlpepkctlnr")
    public suspend fun s3FailurePath(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.s3FailurePath = mapped
    }

    /**
     * @param value The Amazon S3 location to upload inference responses to.
     */
    @JvmName("wgqyartubinvtpwc")
    public suspend fun s3OutputPath(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.s3OutputPath = mapped
    }

    internal fun build(): EndpointConfigurationAsyncInferenceConfigOutputConfigArgs =
        EndpointConfigurationAsyncInferenceConfigOutputConfigArgs(
            kmsKeyId = kmsKeyId,
            notificationConfig = notificationConfig,
            s3FailurePath = s3FailurePath,
            s3OutputPath = s3OutputPath ?: throw PulumiNullFieldException("s3OutputPath"),
        )
}
