@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.sagemaker.kotlin.inputs

import com.pulumi.aws.sagemaker.inputs.EndpointConfigurationProductionVariantRoutingConfigArgs.builder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiNullFieldException
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.String
import kotlin.Suppress
import kotlin.jvm.JvmName

/**
 *
 * @property routingStrategy Sets how the endpoint routes incoming traffic. Valid values are `LEAST_OUTSTANDING_REQUESTS` and `RANDOM`. `LEAST_OUTSTANDING_REQUESTS` routes requests to the specific instances that have more capacity to process them. `RANDOM` routes each request to a randomly chosen instance.
 */
public data class EndpointConfigurationProductionVariantRoutingConfigArgs(
    public val routingStrategy: Output<String>,
) :
    ConvertibleToJava<com.pulumi.aws.sagemaker.inputs.EndpointConfigurationProductionVariantRoutingConfigArgs> {
    override fun toJava(): com.pulumi.aws.sagemaker.inputs.EndpointConfigurationProductionVariantRoutingConfigArgs =
        com.pulumi.aws.sagemaker.inputs.EndpointConfigurationProductionVariantRoutingConfigArgs.builder()
            .routingStrategy(routingStrategy.applyValue({ args0 -> args0 })).build()
}

/**
 * Builder for [EndpointConfigurationProductionVariantRoutingConfigArgs].
 */
@PulumiTagMarker
public class EndpointConfigurationProductionVariantRoutingConfigArgsBuilder internal constructor() {
    private var routingStrategy: Output<String>? = null

    /**
     * @param value Sets how the endpoint routes incoming traffic. Valid values are `LEAST_OUTSTANDING_REQUESTS` and `RANDOM`. `LEAST_OUTSTANDING_REQUESTS` routes requests to the specific instances that have more capacity to process them. `RANDOM` routes each request to a randomly chosen instance.
     */
    @JvmName("rjfpkktpsuacuukn")
    public suspend fun routingStrategy(`value`: Output<String>) {
        this.routingStrategy = value
    }

    /**
     * @param value Sets how the endpoint routes incoming traffic. Valid values are `LEAST_OUTSTANDING_REQUESTS` and `RANDOM`. `LEAST_OUTSTANDING_REQUESTS` routes requests to the specific instances that have more capacity to process them. `RANDOM` routes each request to a randomly chosen instance.
     */
    @JvmName("qnkmihrtyqoetwns")
    public suspend fun routingStrategy(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.routingStrategy = mapped
    }

    internal fun build(): EndpointConfigurationProductionVariantRoutingConfigArgs =
        EndpointConfigurationProductionVariantRoutingConfigArgs(
            routingStrategy = routingStrategy ?: throw PulumiNullFieldException("routingStrategy"),
        )
}
