@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.sagemaker.kotlin.inputs

import com.pulumi.aws.sagemaker.inputs.EndpointDeploymentConfigArgs.builder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.applySuspend
import kotlin.Suppress
import kotlin.Unit
import kotlin.jvm.JvmName

/**
 *
 * @property autoRollbackConfiguration Automatic rollback configuration for handling endpoint deployment failures and recovery. See Auto Rollback Configuration.
 * @property blueGreenUpdatePolicy Update policy for a blue/green deployment. If this update policy is specified, SageMaker creates a new fleet during the deployment while maintaining the old fleet. SageMaker flips traffic to the new fleet according to the specified traffic routing configuration. Only one update policy should be used in the deployment configuration. If no update policy is specified, SageMaker uses a blue/green deployment strategy with all at once traffic shifting by default. See Blue Green Update Config.
 * @property rollingUpdatePolicy Specifies a rolling deployment strategy for updating a SageMaker endpoint. See Rolling Update Policy.
 */
public data class EndpointDeploymentConfigArgs(
    public val autoRollbackConfiguration: Output<EndpointDeploymentConfigAutoRollbackConfigurationArgs>? = null,
    public val blueGreenUpdatePolicy: Output<EndpointDeploymentConfigBlueGreenUpdatePolicyArgs>? =
        null,
    public val rollingUpdatePolicy: Output<EndpointDeploymentConfigRollingUpdatePolicyArgs>? = null,
) : ConvertibleToJava<com.pulumi.aws.sagemaker.inputs.EndpointDeploymentConfigArgs> {
    override fun toJava(): com.pulumi.aws.sagemaker.inputs.EndpointDeploymentConfigArgs =
        com.pulumi.aws.sagemaker.inputs.EndpointDeploymentConfigArgs.builder()
            .autoRollbackConfiguration(
                autoRollbackConfiguration?.applyValue({ args0 ->
                    args0.let({ args0 ->
                        args0.toJava()
                    })
                }),
            )
            .blueGreenUpdatePolicy(
                blueGreenUpdatePolicy?.applyValue({ args0 ->
                    args0.let({ args0 ->
                        args0.toJava()
                    })
                }),
            )
            .rollingUpdatePolicy(
                rollingUpdatePolicy?.applyValue({ args0 ->
                    args0.let({ args0 ->
                        args0.toJava()
                    })
                }),
            ).build()
}

/**
 * Builder for [EndpointDeploymentConfigArgs].
 */
@PulumiTagMarker
public class EndpointDeploymentConfigArgsBuilder internal constructor() {
    private var autoRollbackConfiguration:
        Output<EndpointDeploymentConfigAutoRollbackConfigurationArgs>? = null

    private var blueGreenUpdatePolicy: Output<EndpointDeploymentConfigBlueGreenUpdatePolicyArgs>? =
        null

    private var rollingUpdatePolicy: Output<EndpointDeploymentConfigRollingUpdatePolicyArgs>? = null

    /**
     * @param value Automatic rollback configuration for handling endpoint deployment failures and recovery. See Auto Rollback Configuration.
     */
    @JvmName("mlbjmdhtitiywqqg")
    public suspend fun autoRollbackConfiguration(`value`: Output<EndpointDeploymentConfigAutoRollbackConfigurationArgs>) {
        this.autoRollbackConfiguration = value
    }

    /**
     * @param value Update policy for a blue/green deployment. If this update policy is specified, SageMaker creates a new fleet during the deployment while maintaining the old fleet. SageMaker flips traffic to the new fleet according to the specified traffic routing configuration. Only one update policy should be used in the deployment configuration. If no update policy is specified, SageMaker uses a blue/green deployment strategy with all at once traffic shifting by default. See Blue Green Update Config.
     */
    @JvmName("cletuwpiboatveix")
    public suspend fun blueGreenUpdatePolicy(`value`: Output<EndpointDeploymentConfigBlueGreenUpdatePolicyArgs>) {
        this.blueGreenUpdatePolicy = value
    }

    /**
     * @param value Specifies a rolling deployment strategy for updating a SageMaker endpoint. See Rolling Update Policy.
     */
    @JvmName("jmtsclengjqsqyeg")
    public suspend fun rollingUpdatePolicy(`value`: Output<EndpointDeploymentConfigRollingUpdatePolicyArgs>) {
        this.rollingUpdatePolicy = value
    }

    /**
     * @param value Automatic rollback configuration for handling endpoint deployment failures and recovery. See Auto Rollback Configuration.
     */
    @JvmName("hbvqjbbqlsikkcjf")
    public suspend fun autoRollbackConfiguration(`value`: EndpointDeploymentConfigAutoRollbackConfigurationArgs?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.autoRollbackConfiguration = mapped
    }

    /**
     * @param argument Automatic rollback configuration for handling endpoint deployment failures and recovery. See Auto Rollback Configuration.
     */
    @JvmName("twqnxjmqdsumepwt")
    public suspend fun autoRollbackConfiguration(argument: suspend EndpointDeploymentConfigAutoRollbackConfigurationArgsBuilder.() -> Unit) {
        val toBeMapped = EndpointDeploymentConfigAutoRollbackConfigurationArgsBuilder().applySuspend {
            argument()
        }.build()
        val mapped = of(toBeMapped)
        this.autoRollbackConfiguration = mapped
    }

    /**
     * @param value Update policy for a blue/green deployment. If this update policy is specified, SageMaker creates a new fleet during the deployment while maintaining the old fleet. SageMaker flips traffic to the new fleet according to the specified traffic routing configuration. Only one update policy should be used in the deployment configuration. If no update policy is specified, SageMaker uses a blue/green deployment strategy with all at once traffic shifting by default. See Blue Green Update Config.
     */
    @JvmName("cmxshkbkmctklike")
    public suspend fun blueGreenUpdatePolicy(`value`: EndpointDeploymentConfigBlueGreenUpdatePolicyArgs?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.blueGreenUpdatePolicy = mapped
    }

    /**
     * @param argument Update policy for a blue/green deployment. If this update policy is specified, SageMaker creates a new fleet during the deployment while maintaining the old fleet. SageMaker flips traffic to the new fleet according to the specified traffic routing configuration. Only one update policy should be used in the deployment configuration. If no update policy is specified, SageMaker uses a blue/green deployment strategy with all at once traffic shifting by default. See Blue Green Update Config.
     */
    @JvmName("gltkrkuekaqxwngr")
    public suspend fun blueGreenUpdatePolicy(argument: suspend EndpointDeploymentConfigBlueGreenUpdatePolicyArgsBuilder.() -> Unit) {
        val toBeMapped = EndpointDeploymentConfigBlueGreenUpdatePolicyArgsBuilder().applySuspend {
            argument()
        }.build()
        val mapped = of(toBeMapped)
        this.blueGreenUpdatePolicy = mapped
    }

    /**
     * @param value Specifies a rolling deployment strategy for updating a SageMaker endpoint. See Rolling Update Policy.
     */
    @JvmName("ymuujccibqnlapgc")
    public suspend fun rollingUpdatePolicy(`value`: EndpointDeploymentConfigRollingUpdatePolicyArgs?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.rollingUpdatePolicy = mapped
    }

    /**
     * @param argument Specifies a rolling deployment strategy for updating a SageMaker endpoint. See Rolling Update Policy.
     */
    @JvmName("uhurruslcdytmytu")
    public suspend fun rollingUpdatePolicy(argument: suspend EndpointDeploymentConfigRollingUpdatePolicyArgsBuilder.() -> Unit) {
        val toBeMapped = EndpointDeploymentConfigRollingUpdatePolicyArgsBuilder().applySuspend {
            argument()
        }.build()
        val mapped = of(toBeMapped)
        this.rollingUpdatePolicy = mapped
    }

    internal fun build(): EndpointDeploymentConfigArgs = EndpointDeploymentConfigArgs(
        autoRollbackConfiguration = autoRollbackConfiguration,
        blueGreenUpdatePolicy = blueGreenUpdatePolicy,
        rollingUpdatePolicy = rollingUpdatePolicy,
    )
}
