@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.sagemaker.kotlin.inputs

import com.pulumi.aws.sagemaker.inputs.EndpointDeploymentConfigAutoRollbackConfigurationAlarmArgs.builder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiNullFieldException
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.String
import kotlin.Suppress
import kotlin.jvm.JvmName

/**
 *
 * @property alarmName The name of a CloudWatch alarm in your account.
 */
public data class EndpointDeploymentConfigAutoRollbackConfigurationAlarmArgs(
    public val alarmName: Output<String>,
) :
    ConvertibleToJava<com.pulumi.aws.sagemaker.inputs.EndpointDeploymentConfigAutoRollbackConfigurationAlarmArgs> {
    override fun toJava(): com.pulumi.aws.sagemaker.inputs.EndpointDeploymentConfigAutoRollbackConfigurationAlarmArgs =
        com.pulumi.aws.sagemaker.inputs.EndpointDeploymentConfigAutoRollbackConfigurationAlarmArgs.builder()
            .alarmName(alarmName.applyValue({ args0 -> args0 })).build()
}

/**
 * Builder for [EndpointDeploymentConfigAutoRollbackConfigurationAlarmArgs].
 */
@PulumiTagMarker
public class EndpointDeploymentConfigAutoRollbackConfigurationAlarmArgsBuilder internal constructor() {
    private var alarmName: Output<String>? = null

    /**
     * @param value The name of a CloudWatch alarm in your account.
     */
    @JvmName("axqmseelbuicyjxe")
    public suspend fun alarmName(`value`: Output<String>) {
        this.alarmName = value
    }

    /**
     * @param value The name of a CloudWatch alarm in your account.
     */
    @JvmName("iouwcbsibivvfsur")
    public suspend fun alarmName(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.alarmName = mapped
    }

    internal fun build(): EndpointDeploymentConfigAutoRollbackConfigurationAlarmArgs =
        EndpointDeploymentConfigAutoRollbackConfigurationAlarmArgs(
            alarmName = alarmName ?: throw PulumiNullFieldException("alarmName"),
        )
}
