@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.sagemaker.kotlin.inputs

import com.pulumi.aws.sagemaker.inputs.EndpointDeploymentConfigAutoRollbackConfigurationArgs.builder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.applySuspend
import kotlin.Suppress
import kotlin.Unit
import kotlin.collections.List
import kotlin.jvm.JvmName

/**
 *
 * @property alarms List of CloudWatch alarms in your account that are configured to monitor metrics on an endpoint. If any alarms are tripped during a deployment, SageMaker rolls back the deployment. See Alarms.
 */
public data class EndpointDeploymentConfigAutoRollbackConfigurationArgs(
    public val alarms: Output<List<EndpointDeploymentConfigAutoRollbackConfigurationAlarmArgs>>? =
        null,
) :
    ConvertibleToJava<com.pulumi.aws.sagemaker.inputs.EndpointDeploymentConfigAutoRollbackConfigurationArgs> {
    override fun toJava(): com.pulumi.aws.sagemaker.inputs.EndpointDeploymentConfigAutoRollbackConfigurationArgs =
        com.pulumi.aws.sagemaker.inputs.EndpointDeploymentConfigAutoRollbackConfigurationArgs.builder()
            .alarms(
                alarms?.applyValue({ args0 ->
                    args0.map({ args0 ->
                        args0.let({ args0 ->
                            args0.toJava()
                        })
                    })
                }),
            ).build()
}

/**
 * Builder for [EndpointDeploymentConfigAutoRollbackConfigurationArgs].
 */
@PulumiTagMarker
public class EndpointDeploymentConfigAutoRollbackConfigurationArgsBuilder internal constructor() {
    private var alarms: Output<List<EndpointDeploymentConfigAutoRollbackConfigurationAlarmArgs>>? =
        null

    /**
     * @param value List of CloudWatch alarms in your account that are configured to monitor metrics on an endpoint. If any alarms are tripped during a deployment, SageMaker rolls back the deployment. See Alarms.
     */
    @JvmName("rdkihxmgaqsytwva")
    public suspend fun alarms(`value`: Output<List<EndpointDeploymentConfigAutoRollbackConfigurationAlarmArgs>>) {
        this.alarms = value
    }

    @JvmName("tjravgqarxjoikax")
    public suspend fun alarms(vararg values: Output<EndpointDeploymentConfigAutoRollbackConfigurationAlarmArgs>) {
        this.alarms = Output.all(values.asList())
    }

    /**
     * @param values List of CloudWatch alarms in your account that are configured to monitor metrics on an endpoint. If any alarms are tripped during a deployment, SageMaker rolls back the deployment. See Alarms.
     */
    @JvmName("xaniyyuvygenrrut")
    public suspend fun alarms(values: List<Output<EndpointDeploymentConfigAutoRollbackConfigurationAlarmArgs>>) {
        this.alarms = Output.all(values)
    }

    /**
     * @param value List of CloudWatch alarms in your account that are configured to monitor metrics on an endpoint. If any alarms are tripped during a deployment, SageMaker rolls back the deployment. See Alarms.
     */
    @JvmName("rttfiguqhsnbrojw")
    public suspend fun alarms(`value`: List<EndpointDeploymentConfigAutoRollbackConfigurationAlarmArgs>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.alarms = mapped
    }

    /**
     * @param argument List of CloudWatch alarms in your account that are configured to monitor metrics on an endpoint. If any alarms are tripped during a deployment, SageMaker rolls back the deployment. See Alarms.
     */
    @JvmName("upjbonyfvdgvogmb")
    public suspend fun alarms(argument: List<suspend EndpointDeploymentConfigAutoRollbackConfigurationAlarmArgsBuilder.() -> Unit>) {
        val toBeMapped = argument.toList().map {
            EndpointDeploymentConfigAutoRollbackConfigurationAlarmArgsBuilder().applySuspend {
                it()
            }.build()
        }
        val mapped = of(toBeMapped)
        this.alarms = mapped
    }

    /**
     * @param argument List of CloudWatch alarms in your account that are configured to monitor metrics on an endpoint. If any alarms are tripped during a deployment, SageMaker rolls back the deployment. See Alarms.
     */
    @JvmName("itwvyenspjqfotjg")
    public suspend fun alarms(vararg argument: suspend EndpointDeploymentConfigAutoRollbackConfigurationAlarmArgsBuilder.() -> Unit) {
        val toBeMapped = argument.toList().map {
            EndpointDeploymentConfigAutoRollbackConfigurationAlarmArgsBuilder().applySuspend {
                it()
            }.build()
        }
        val mapped = of(toBeMapped)
        this.alarms = mapped
    }

    /**
     * @param argument List of CloudWatch alarms in your account that are configured to monitor metrics on an endpoint. If any alarms are tripped during a deployment, SageMaker rolls back the deployment. See Alarms.
     */
    @JvmName("bhreienpvaggjoga")
    public suspend fun alarms(argument: suspend EndpointDeploymentConfigAutoRollbackConfigurationAlarmArgsBuilder.() -> Unit) {
        val toBeMapped =
            listOf(
                EndpointDeploymentConfigAutoRollbackConfigurationAlarmArgsBuilder().applySuspend {
                    argument()
                }.build(),
            )
        val mapped = of(toBeMapped)
        this.alarms = mapped
    }

    /**
     * @param values List of CloudWatch alarms in your account that are configured to monitor metrics on an endpoint. If any alarms are tripped during a deployment, SageMaker rolls back the deployment. See Alarms.
     */
    @JvmName("tjakuspuafeitlly")
    public suspend fun alarms(vararg values: EndpointDeploymentConfigAutoRollbackConfigurationAlarmArgs) {
        val toBeMapped = values.toList()
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.alarms = mapped
    }

    internal fun build(): EndpointDeploymentConfigAutoRollbackConfigurationArgs =
        EndpointDeploymentConfigAutoRollbackConfigurationArgs(
            alarms = alarms,
        )
}
