@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.sagemaker.kotlin.inputs

import com.pulumi.aws.sagemaker.inputs.EndpointDeploymentConfigBlueGreenUpdatePolicyArgs.builder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiNullFieldException
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.applySuspend
import kotlin.Int
import kotlin.Suppress
import kotlin.Unit
import kotlin.jvm.JvmName

/**
 *
 * @property maximumExecutionTimeoutInSeconds
 * @property terminationWaitInSeconds Additional waiting time in seconds after the completion of an endpoint deployment before terminating the old endpoint fleet. Default is `0`. Valid values are between `0` and `3600`.
 * @property trafficRoutingConfiguration Defines the traffic routing strategy to shift traffic from the old fleet to the new fleet during an endpoint deployment. See Traffic Routing Configuration.
 */
public data class EndpointDeploymentConfigBlueGreenUpdatePolicyArgs(
    public val maximumExecutionTimeoutInSeconds: Output<Int>? = null,
    public val terminationWaitInSeconds: Output<Int>? = null,
    public val trafficRoutingConfiguration: Output<EndpointDeploymentConfigBlueGreenUpdatePolicyTrafficRoutingConfigurationArgs>,
) :
    ConvertibleToJava<com.pulumi.aws.sagemaker.inputs.EndpointDeploymentConfigBlueGreenUpdatePolicyArgs> {
    override fun toJava(): com.pulumi.aws.sagemaker.inputs.EndpointDeploymentConfigBlueGreenUpdatePolicyArgs =
        com.pulumi.aws.sagemaker.inputs.EndpointDeploymentConfigBlueGreenUpdatePolicyArgs.builder()
            .maximumExecutionTimeoutInSeconds(maximumExecutionTimeoutInSeconds?.applyValue({ args0 -> args0 }))
            .terminationWaitInSeconds(terminationWaitInSeconds?.applyValue({ args0 -> args0 }))
            .trafficRoutingConfiguration(
                trafficRoutingConfiguration.applyValue({ args0 ->
                    args0.let({ args0 ->
                        args0.toJava()
                    })
                }),
            ).build()
}

/**
 * Builder for [EndpointDeploymentConfigBlueGreenUpdatePolicyArgs].
 */
@PulumiTagMarker
public class EndpointDeploymentConfigBlueGreenUpdatePolicyArgsBuilder internal constructor() {
    private var maximumExecutionTimeoutInSeconds: Output<Int>? = null

    private var terminationWaitInSeconds: Output<Int>? = null

    private var trafficRoutingConfiguration:
        Output<EndpointDeploymentConfigBlueGreenUpdatePolicyTrafficRoutingConfigurationArgs>? = null

    /**
     * @param value
     */
    @JvmName("xeneodrbegkirmhu")
    public suspend fun maximumExecutionTimeoutInSeconds(`value`: Output<Int>) {
        this.maximumExecutionTimeoutInSeconds = value
    }

    /**
     * @param value Additional waiting time in seconds after the completion of an endpoint deployment before terminating the old endpoint fleet. Default is `0`. Valid values are between `0` and `3600`.
     */
    @JvmName("pdqopyfsbtuqowoc")
    public suspend fun terminationWaitInSeconds(`value`: Output<Int>) {
        this.terminationWaitInSeconds = value
    }

    /**
     * @param value Defines the traffic routing strategy to shift traffic from the old fleet to the new fleet during an endpoint deployment. See Traffic Routing Configuration.
     */
    @JvmName("qmvlnmdahvneuhva")
    public suspend fun trafficRoutingConfiguration(`value`: Output<EndpointDeploymentConfigBlueGreenUpdatePolicyTrafficRoutingConfigurationArgs>) {
        this.trafficRoutingConfiguration = value
    }

    /**
     * @param value
     */
    @JvmName("xttpcdpbpncvceja")
    public suspend fun maximumExecutionTimeoutInSeconds(`value`: Int?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.maximumExecutionTimeoutInSeconds = mapped
    }

    /**
     * @param value Additional waiting time in seconds after the completion of an endpoint deployment before terminating the old endpoint fleet. Default is `0`. Valid values are between `0` and `3600`.
     */
    @JvmName("ogqqqpjuvyakqdjj")
    public suspend fun terminationWaitInSeconds(`value`: Int?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.terminationWaitInSeconds = mapped
    }

    /**
     * @param value Defines the traffic routing strategy to shift traffic from the old fleet to the new fleet during an endpoint deployment. See Traffic Routing Configuration.
     */
    @JvmName("ubwxnegnfiroklhq")
    public suspend fun trafficRoutingConfiguration(`value`: EndpointDeploymentConfigBlueGreenUpdatePolicyTrafficRoutingConfigurationArgs) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.trafficRoutingConfiguration = mapped
    }

    /**
     * @param argument Defines the traffic routing strategy to shift traffic from the old fleet to the new fleet during an endpoint deployment. See Traffic Routing Configuration.
     */
    @JvmName("xvrgluqaufwsunvb")
    public suspend fun trafficRoutingConfiguration(argument: suspend EndpointDeploymentConfigBlueGreenUpdatePolicyTrafficRoutingConfigurationArgsBuilder.() -> Unit) {
        val toBeMapped =
            EndpointDeploymentConfigBlueGreenUpdatePolicyTrafficRoutingConfigurationArgsBuilder().applySuspend {
                argument()
            }.build()
        val mapped = of(toBeMapped)
        this.trafficRoutingConfiguration = mapped
    }

    internal fun build(): EndpointDeploymentConfigBlueGreenUpdatePolicyArgs =
        EndpointDeploymentConfigBlueGreenUpdatePolicyArgs(
            maximumExecutionTimeoutInSeconds = maximumExecutionTimeoutInSeconds,
            terminationWaitInSeconds = terminationWaitInSeconds,
            trafficRoutingConfiguration = trafficRoutingConfiguration ?: throw
                PulumiNullFieldException("trafficRoutingConfiguration"),
        )
}
