@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.sagemaker.kotlin.inputs

import com.pulumi.aws.sagemaker.inputs.EndpointDeploymentConfigRollingUpdatePolicyArgs.builder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiNullFieldException
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.applySuspend
import kotlin.Int
import kotlin.Suppress
import kotlin.Unit
import kotlin.jvm.JvmName

/**
 *
 * @property maximumBatchSize Batch size for each rolling step to provision capacity and turn on traffic on the new endpoint fleet, and terminate capacity on the old endpoint fleet. Value must be between 5% to 50% of the variant's total instance count. See Maximum Batch Size.
 * @property maximumExecutionTimeoutInSeconds The time limit for the total deployment. Exceeding this limit causes a timeout. Valid values are between `600` and `14400`.
 * @property rollbackMaximumBatchSize Batch size for rollback to the old endpoint fleet. Each rolling step to provision capacity and turn on traffic on the old endpoint fleet, and terminate capacity on the new endpoint fleet. If this field is absent, the default value will be set to 100% of total capacity which means to bring up the whole capacity of the old fleet at once during rollback. See Rollback Maximum Batch Size.
 * @property waitIntervalInSeconds The length of the baking period, during which SageMaker monitors alarms for each batch on the new fleet. Valid values are between `0` and `3600`.
 */
public data class EndpointDeploymentConfigRollingUpdatePolicyArgs(
    public val maximumBatchSize: Output<EndpointDeploymentConfigRollingUpdatePolicyMaximumBatchSizeArgs>,
    public val maximumExecutionTimeoutInSeconds: Output<Int>? = null,
    public val rollbackMaximumBatchSize: Output<EndpointDeploymentConfigRollingUpdatePolicyRollbackMaximumBatchSizeArgs>? = null,
    public val waitIntervalInSeconds: Output<Int>,
) :
    ConvertibleToJava<com.pulumi.aws.sagemaker.inputs.EndpointDeploymentConfigRollingUpdatePolicyArgs> {
    override fun toJava(): com.pulumi.aws.sagemaker.inputs.EndpointDeploymentConfigRollingUpdatePolicyArgs =
        com.pulumi.aws.sagemaker.inputs.EndpointDeploymentConfigRollingUpdatePolicyArgs.builder()
            .maximumBatchSize(maximumBatchSize.applyValue({ args0 -> args0.let({ args0 -> args0.toJava() }) }))
            .maximumExecutionTimeoutInSeconds(maximumExecutionTimeoutInSeconds?.applyValue({ args0 -> args0 }))
            .rollbackMaximumBatchSize(
                rollbackMaximumBatchSize?.applyValue({ args0 ->
                    args0.let({ args0 ->
                        args0.toJava()
                    })
                }),
            )
            .waitIntervalInSeconds(waitIntervalInSeconds.applyValue({ args0 -> args0 })).build()
}

/**
 * Builder for [EndpointDeploymentConfigRollingUpdatePolicyArgs].
 */
@PulumiTagMarker
public class EndpointDeploymentConfigRollingUpdatePolicyArgsBuilder internal constructor() {
    private var maximumBatchSize:
        Output<EndpointDeploymentConfigRollingUpdatePolicyMaximumBatchSizeArgs>? = null

    private var maximumExecutionTimeoutInSeconds: Output<Int>? = null

    private var rollbackMaximumBatchSize:
        Output<EndpointDeploymentConfigRollingUpdatePolicyRollbackMaximumBatchSizeArgs>? = null

    private var waitIntervalInSeconds: Output<Int>? = null

    /**
     * @param value Batch size for each rolling step to provision capacity and turn on traffic on the new endpoint fleet, and terminate capacity on the old endpoint fleet. Value must be between 5% to 50% of the variant's total instance count. See Maximum Batch Size.
     */
    @JvmName("kdhdcxapvfntdpep")
    public suspend fun maximumBatchSize(`value`: Output<EndpointDeploymentConfigRollingUpdatePolicyMaximumBatchSizeArgs>) {
        this.maximumBatchSize = value
    }

    /**
     * @param value The time limit for the total deployment. Exceeding this limit causes a timeout. Valid values are between `600` and `14400`.
     */
    @JvmName("rordrlqhqeatsxpv")
    public suspend fun maximumExecutionTimeoutInSeconds(`value`: Output<Int>) {
        this.maximumExecutionTimeoutInSeconds = value
    }

    /**
     * @param value Batch size for rollback to the old endpoint fleet. Each rolling step to provision capacity and turn on traffic on the old endpoint fleet, and terminate capacity on the new endpoint fleet. If this field is absent, the default value will be set to 100% of total capacity which means to bring up the whole capacity of the old fleet at once during rollback. See Rollback Maximum Batch Size.
     */
    @JvmName("diegxavddjfpdxql")
    public suspend fun rollbackMaximumBatchSize(`value`: Output<EndpointDeploymentConfigRollingUpdatePolicyRollbackMaximumBatchSizeArgs>) {
        this.rollbackMaximumBatchSize = value
    }

    /**
     * @param value The length of the baking period, during which SageMaker monitors alarms for each batch on the new fleet. Valid values are between `0` and `3600`.
     */
    @JvmName("jpfnexhruludtcle")
    public suspend fun waitIntervalInSeconds(`value`: Output<Int>) {
        this.waitIntervalInSeconds = value
    }

    /**
     * @param value Batch size for each rolling step to provision capacity and turn on traffic on the new endpoint fleet, and terminate capacity on the old endpoint fleet. Value must be between 5% to 50% of the variant's total instance count. See Maximum Batch Size.
     */
    @JvmName("ghhhwwmhxnvkuaud")
    public suspend fun maximumBatchSize(`value`: EndpointDeploymentConfigRollingUpdatePolicyMaximumBatchSizeArgs) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.maximumBatchSize = mapped
    }

    /**
     * @param argument Batch size for each rolling step to provision capacity and turn on traffic on the new endpoint fleet, and terminate capacity on the old endpoint fleet. Value must be between 5% to 50% of the variant's total instance count. See Maximum Batch Size.
     */
    @JvmName("xaphukpihrvgypkg")
    public suspend fun maximumBatchSize(argument: suspend EndpointDeploymentConfigRollingUpdatePolicyMaximumBatchSizeArgsBuilder.() -> Unit) {
        val toBeMapped =
            EndpointDeploymentConfigRollingUpdatePolicyMaximumBatchSizeArgsBuilder().applySuspend {
                argument()
            }.build()
        val mapped = of(toBeMapped)
        this.maximumBatchSize = mapped
    }

    /**
     * @param value The time limit for the total deployment. Exceeding this limit causes a timeout. Valid values are between `600` and `14400`.
     */
    @JvmName("oxccgwleowmdmtmb")
    public suspend fun maximumExecutionTimeoutInSeconds(`value`: Int?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.maximumExecutionTimeoutInSeconds = mapped
    }

    /**
     * @param value Batch size for rollback to the old endpoint fleet. Each rolling step to provision capacity and turn on traffic on the old endpoint fleet, and terminate capacity on the new endpoint fleet. If this field is absent, the default value will be set to 100% of total capacity which means to bring up the whole capacity of the old fleet at once during rollback. See Rollback Maximum Batch Size.
     */
    @JvmName("tluhyopymflrhqoa")
    public suspend fun rollbackMaximumBatchSize(`value`: EndpointDeploymentConfigRollingUpdatePolicyRollbackMaximumBatchSizeArgs?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.rollbackMaximumBatchSize = mapped
    }

    /**
     * @param argument Batch size for rollback to the old endpoint fleet. Each rolling step to provision capacity and turn on traffic on the old endpoint fleet, and terminate capacity on the new endpoint fleet. If this field is absent, the default value will be set to 100% of total capacity which means to bring up the whole capacity of the old fleet at once during rollback. See Rollback Maximum Batch Size.
     */
    @JvmName("abewfpejmimliryt")
    public suspend fun rollbackMaximumBatchSize(argument: suspend EndpointDeploymentConfigRollingUpdatePolicyRollbackMaximumBatchSizeArgsBuilder.() -> Unit) {
        val toBeMapped =
            EndpointDeploymentConfigRollingUpdatePolicyRollbackMaximumBatchSizeArgsBuilder().applySuspend {
                argument()
            }.build()
        val mapped = of(toBeMapped)
        this.rollbackMaximumBatchSize = mapped
    }

    /**
     * @param value The length of the baking period, during which SageMaker monitors alarms for each batch on the new fleet. Valid values are between `0` and `3600`.
     */
    @JvmName("yuxpbxxokwwgcbnm")
    public suspend fun waitIntervalInSeconds(`value`: Int) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.waitIntervalInSeconds = mapped
    }

    internal fun build(): EndpointDeploymentConfigRollingUpdatePolicyArgs =
        EndpointDeploymentConfigRollingUpdatePolicyArgs(
            maximumBatchSize = maximumBatchSize ?: throw PulumiNullFieldException("maximumBatchSize"),
            maximumExecutionTimeoutInSeconds = maximumExecutionTimeoutInSeconds,
            rollbackMaximumBatchSize = rollbackMaximumBatchSize,
            waitIntervalInSeconds = waitIntervalInSeconds ?: throw
                PulumiNullFieldException("waitIntervalInSeconds"),
        )
}
