@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.sagemaker.kotlin.inputs

import com.pulumi.aws.sagemaker.inputs.FeatureGroupFeatureDefinitionArgs.builder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.String
import kotlin.Suppress
import kotlin.jvm.JvmName

/**
 *
 * @property featureName The name of a feature. `feature_name` cannot be any of the following: `is_deleted`, `write_time`, `api_invocation_time`.
 * @property featureType The value type of a feature. Valid values are `Integral`, `Fractional`, or `String`.
 */
public data class FeatureGroupFeatureDefinitionArgs(
    public val featureName: Output<String>? = null,
    public val featureType: Output<String>? = null,
) : ConvertibleToJava<com.pulumi.aws.sagemaker.inputs.FeatureGroupFeatureDefinitionArgs> {
    override fun toJava(): com.pulumi.aws.sagemaker.inputs.FeatureGroupFeatureDefinitionArgs =
        com.pulumi.aws.sagemaker.inputs.FeatureGroupFeatureDefinitionArgs.builder()
            .featureName(featureName?.applyValue({ args0 -> args0 }))
            .featureType(featureType?.applyValue({ args0 -> args0 })).build()
}

/**
 * Builder for [FeatureGroupFeatureDefinitionArgs].
 */
@PulumiTagMarker
public class FeatureGroupFeatureDefinitionArgsBuilder internal constructor() {
    private var featureName: Output<String>? = null

    private var featureType: Output<String>? = null

    /**
     * @param value The name of a feature. `feature_name` cannot be any of the following: `is_deleted`, `write_time`, `api_invocation_time`.
     */
    @JvmName("bvonoqlepwvlrnmu")
    public suspend fun featureName(`value`: Output<String>) {
        this.featureName = value
    }

    /**
     * @param value The value type of a feature. Valid values are `Integral`, `Fractional`, or `String`.
     */
    @JvmName("ygexawxcuycbllxq")
    public suspend fun featureType(`value`: Output<String>) {
        this.featureType = value
    }

    /**
     * @param value The name of a feature. `feature_name` cannot be any of the following: `is_deleted`, `write_time`, `api_invocation_time`.
     */
    @JvmName("ffgfsqqeptfahdww")
    public suspend fun featureName(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.featureName = mapped
    }

    /**
     * @param value The value type of a feature. Valid values are `Integral`, `Fractional`, or `String`.
     */
    @JvmName("qxhufpgrdkreenos")
    public suspend fun featureType(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.featureType = mapped
    }

    internal fun build(): FeatureGroupFeatureDefinitionArgs = FeatureGroupFeatureDefinitionArgs(
        featureName = featureName,
        featureType = featureType,
    )
}
