@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.sagemaker.kotlin.inputs

import com.pulumi.aws.sagemaker.inputs.FeatureGroupOfflineStoreConfigArgs.builder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiNullFieldException
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.applySuspend
import kotlin.Boolean
import kotlin.String
import kotlin.Suppress
import kotlin.Unit
import kotlin.jvm.JvmName

/**
 *
 * @property dataCatalogConfig The meta data of the Glue table that is autogenerated when an OfflineStore is created. See Data Catalog Config Below.
 * @property disableGlueTableCreation Set to `true` to turn Online Store On.
 * @property s3StorageConfig The Amazon Simple Storage (Amazon S3) location of OfflineStore. See S3 Storage Config Below.
 * @property tableFormat Format for the offline store table. Supported formats are `Glue` (Default) and Apache `Iceberg` (https://iceberg.apache.org/).
 */
public data class FeatureGroupOfflineStoreConfigArgs(
    public val dataCatalogConfig: Output<FeatureGroupOfflineStoreConfigDataCatalogConfigArgs>? = null,
    public val disableGlueTableCreation: Output<Boolean>? = null,
    public val s3StorageConfig: Output<FeatureGroupOfflineStoreConfigS3StorageConfigArgs>,
    public val tableFormat: Output<String>? = null,
) : ConvertibleToJava<com.pulumi.aws.sagemaker.inputs.FeatureGroupOfflineStoreConfigArgs> {
    override fun toJava(): com.pulumi.aws.sagemaker.inputs.FeatureGroupOfflineStoreConfigArgs =
        com.pulumi.aws.sagemaker.inputs.FeatureGroupOfflineStoreConfigArgs.builder()
            .dataCatalogConfig(dataCatalogConfig?.applyValue({ args0 -> args0.let({ args0 -> args0.toJava() }) }))
            .disableGlueTableCreation(disableGlueTableCreation?.applyValue({ args0 -> args0 }))
            .s3StorageConfig(s3StorageConfig.applyValue({ args0 -> args0.let({ args0 -> args0.toJava() }) }))
            .tableFormat(tableFormat?.applyValue({ args0 -> args0 })).build()
}

/**
 * Builder for [FeatureGroupOfflineStoreConfigArgs].
 */
@PulumiTagMarker
public class FeatureGroupOfflineStoreConfigArgsBuilder internal constructor() {
    private var dataCatalogConfig: Output<FeatureGroupOfflineStoreConfigDataCatalogConfigArgs>? = null

    private var disableGlueTableCreation: Output<Boolean>? = null

    private var s3StorageConfig: Output<FeatureGroupOfflineStoreConfigS3StorageConfigArgs>? = null

    private var tableFormat: Output<String>? = null

    /**
     * @param value The meta data of the Glue table that is autogenerated when an OfflineStore is created. See Data Catalog Config Below.
     */
    @JvmName("othqkhdrmwmpaftx")
    public suspend fun dataCatalogConfig(`value`: Output<FeatureGroupOfflineStoreConfigDataCatalogConfigArgs>) {
        this.dataCatalogConfig = value
    }

    /**
     * @param value Set to `true` to turn Online Store On.
     */
    @JvmName("drwxnqmncxundyyr")
    public suspend fun disableGlueTableCreation(`value`: Output<Boolean>) {
        this.disableGlueTableCreation = value
    }

    /**
     * @param value The Amazon Simple Storage (Amazon S3) location of OfflineStore. See S3 Storage Config Below.
     */
    @JvmName("kwjxiesaqmkasjyx")
    public suspend fun s3StorageConfig(`value`: Output<FeatureGroupOfflineStoreConfigS3StorageConfigArgs>) {
        this.s3StorageConfig = value
    }

    /**
     * @param value Format for the offline store table. Supported formats are `Glue` (Default) and Apache `Iceberg` (https://iceberg.apache.org/).
     */
    @JvmName("ugkiqedcxlhcgpxy")
    public suspend fun tableFormat(`value`: Output<String>) {
        this.tableFormat = value
    }

    /**
     * @param value The meta data of the Glue table that is autogenerated when an OfflineStore is created. See Data Catalog Config Below.
     */
    @JvmName("qditrcgncrijnljq")
    public suspend fun dataCatalogConfig(`value`: FeatureGroupOfflineStoreConfigDataCatalogConfigArgs?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.dataCatalogConfig = mapped
    }

    /**
     * @param argument The meta data of the Glue table that is autogenerated when an OfflineStore is created. See Data Catalog Config Below.
     */
    @JvmName("ihcotewggmtshxnf")
    public suspend fun dataCatalogConfig(argument: suspend FeatureGroupOfflineStoreConfigDataCatalogConfigArgsBuilder.() -> Unit) {
        val toBeMapped = FeatureGroupOfflineStoreConfigDataCatalogConfigArgsBuilder().applySuspend {
            argument()
        }.build()
        val mapped = of(toBeMapped)
        this.dataCatalogConfig = mapped
    }

    /**
     * @param value Set to `true` to turn Online Store On.
     */
    @JvmName("fevdtwflxeikavqx")
    public suspend fun disableGlueTableCreation(`value`: Boolean?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.disableGlueTableCreation = mapped
    }

    /**
     * @param value The Amazon Simple Storage (Amazon S3) location of OfflineStore. See S3 Storage Config Below.
     */
    @JvmName("yjoeituabpyqsksf")
    public suspend fun s3StorageConfig(`value`: FeatureGroupOfflineStoreConfigS3StorageConfigArgs) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.s3StorageConfig = mapped
    }

    /**
     * @param argument The Amazon Simple Storage (Amazon S3) location of OfflineStore. See S3 Storage Config Below.
     */
    @JvmName("cgfcvtfwhwbjnlsw")
    public suspend fun s3StorageConfig(argument: suspend FeatureGroupOfflineStoreConfigS3StorageConfigArgsBuilder.() -> Unit) {
        val toBeMapped = FeatureGroupOfflineStoreConfigS3StorageConfigArgsBuilder().applySuspend {
            argument()
        }.build()
        val mapped = of(toBeMapped)
        this.s3StorageConfig = mapped
    }

    /**
     * @param value Format for the offline store table. Supported formats are `Glue` (Default) and Apache `Iceberg` (https://iceberg.apache.org/).
     */
    @JvmName("vhvqenuqasxabuqe")
    public suspend fun tableFormat(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.tableFormat = mapped
    }

    internal fun build(): FeatureGroupOfflineStoreConfigArgs = FeatureGroupOfflineStoreConfigArgs(
        dataCatalogConfig = dataCatalogConfig,
        disableGlueTableCreation = disableGlueTableCreation,
        s3StorageConfig = s3StorageConfig ?: throw PulumiNullFieldException("s3StorageConfig"),
        tableFormat = tableFormat,
    )
}
