@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.sagemaker.kotlin.inputs

import com.pulumi.aws.sagemaker.inputs.FeatureGroupOfflineStoreConfigS3StorageConfigArgs.builder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiNullFieldException
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.String
import kotlin.Suppress
import kotlin.jvm.JvmName

/**
 *
 * @property kmsKeyId The AWS Key Management Service (KMS) key ID of the key used to encrypt any objects written into the OfflineStore S3 location.
 * @property resolvedOutputS3Uri The S3 path where offline records are written.
 * @property s3Uri The S3 URI, or location in Amazon S3, of OfflineStore.
 */
public data class FeatureGroupOfflineStoreConfigS3StorageConfigArgs(
    public val kmsKeyId: Output<String>? = null,
    public val resolvedOutputS3Uri: Output<String>? = null,
    public val s3Uri: Output<String>,
) :
    ConvertibleToJava<com.pulumi.aws.sagemaker.inputs.FeatureGroupOfflineStoreConfigS3StorageConfigArgs> {
    override fun toJava(): com.pulumi.aws.sagemaker.inputs.FeatureGroupOfflineStoreConfigS3StorageConfigArgs =
        com.pulumi.aws.sagemaker.inputs.FeatureGroupOfflineStoreConfigS3StorageConfigArgs.builder()
            .kmsKeyId(kmsKeyId?.applyValue({ args0 -> args0 }))
            .resolvedOutputS3Uri(resolvedOutputS3Uri?.applyValue({ args0 -> args0 }))
            .s3Uri(s3Uri.applyValue({ args0 -> args0 })).build()
}

/**
 * Builder for [FeatureGroupOfflineStoreConfigS3StorageConfigArgs].
 */
@PulumiTagMarker
public class FeatureGroupOfflineStoreConfigS3StorageConfigArgsBuilder internal constructor() {
    private var kmsKeyId: Output<String>? = null

    private var resolvedOutputS3Uri: Output<String>? = null

    private var s3Uri: Output<String>? = null

    /**
     * @param value The AWS Key Management Service (KMS) key ID of the key used to encrypt any objects written into the OfflineStore S3 location.
     */
    @JvmName("smqvchewvwveyckm")
    public suspend fun kmsKeyId(`value`: Output<String>) {
        this.kmsKeyId = value
    }

    /**
     * @param value The S3 path where offline records are written.
     */
    @JvmName("yxuiaqouqkorchvn")
    public suspend fun resolvedOutputS3Uri(`value`: Output<String>) {
        this.resolvedOutputS3Uri = value
    }

    /**
     * @param value The S3 URI, or location in Amazon S3, of OfflineStore.
     */
    @JvmName("iqdfhbnounsgjcbf")
    public suspend fun s3Uri(`value`: Output<String>) {
        this.s3Uri = value
    }

    /**
     * @param value The AWS Key Management Service (KMS) key ID of the key used to encrypt any objects written into the OfflineStore S3 location.
     */
    @JvmName("eenyqqambyaentxy")
    public suspend fun kmsKeyId(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.kmsKeyId = mapped
    }

    /**
     * @param value The S3 path where offline records are written.
     */
    @JvmName("jnqajupqneifjlus")
    public suspend fun resolvedOutputS3Uri(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.resolvedOutputS3Uri = mapped
    }

    /**
     * @param value The S3 URI, or location in Amazon S3, of OfflineStore.
     */
    @JvmName("hehijqfbedfmeikg")
    public suspend fun s3Uri(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.s3Uri = mapped
    }

    internal fun build(): FeatureGroupOfflineStoreConfigS3StorageConfigArgs =
        FeatureGroupOfflineStoreConfigS3StorageConfigArgs(
            kmsKeyId = kmsKeyId,
            resolvedOutputS3Uri = resolvedOutputS3Uri,
            s3Uri = s3Uri ?: throw PulumiNullFieldException("s3Uri"),
        )
}
