@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.sagemaker.kotlin.inputs

import com.pulumi.aws.sagemaker.inputs.FeatureGroupOnlineStoreConfigArgs.builder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.applySuspend
import kotlin.Boolean
import kotlin.String
import kotlin.Suppress
import kotlin.Unit
import kotlin.jvm.JvmName

/**
 *
 * @property enableOnlineStore Set to `true` to disable the automatic creation of an AWS Glue table when configuring an OfflineStore.
 * @property securityConfig Security config for at-rest encryption of your OnlineStore. See Security Config Below.
 * @property storageType Option for different tiers of low latency storage for real-time data retrieval. Valid values are `Standard`, or `InMemory`.
 * @property ttlDuration Time to live duration, where the record is hard deleted after the expiration time is reached; ExpiresAt = EventTime + TtlDuration.. See TTl Duration Below.
 */
public data class FeatureGroupOnlineStoreConfigArgs(
    public val enableOnlineStore: Output<Boolean>? = null,
    public val securityConfig: Output<FeatureGroupOnlineStoreConfigSecurityConfigArgs>? = null,
    public val storageType: Output<String>? = null,
    public val ttlDuration: Output<FeatureGroupOnlineStoreConfigTtlDurationArgs>? = null,
) : ConvertibleToJava<com.pulumi.aws.sagemaker.inputs.FeatureGroupOnlineStoreConfigArgs> {
    override fun toJava(): com.pulumi.aws.sagemaker.inputs.FeatureGroupOnlineStoreConfigArgs =
        com.pulumi.aws.sagemaker.inputs.FeatureGroupOnlineStoreConfigArgs.builder()
            .enableOnlineStore(enableOnlineStore?.applyValue({ args0 -> args0 }))
            .securityConfig(securityConfig?.applyValue({ args0 -> args0.let({ args0 -> args0.toJava() }) }))
            .storageType(storageType?.applyValue({ args0 -> args0 }))
            .ttlDuration(ttlDuration?.applyValue({ args0 -> args0.let({ args0 -> args0.toJava() }) })).build()
}

/**
 * Builder for [FeatureGroupOnlineStoreConfigArgs].
 */
@PulumiTagMarker
public class FeatureGroupOnlineStoreConfigArgsBuilder internal constructor() {
    private var enableOnlineStore: Output<Boolean>? = null

    private var securityConfig: Output<FeatureGroupOnlineStoreConfigSecurityConfigArgs>? = null

    private var storageType: Output<String>? = null

    private var ttlDuration: Output<FeatureGroupOnlineStoreConfigTtlDurationArgs>? = null

    /**
     * @param value Set to `true` to disable the automatic creation of an AWS Glue table when configuring an OfflineStore.
     */
    @JvmName("jshxcxxsxbyyhbqb")
    public suspend fun enableOnlineStore(`value`: Output<Boolean>) {
        this.enableOnlineStore = value
    }

    /**
     * @param value Security config for at-rest encryption of your OnlineStore. See Security Config Below.
     */
    @JvmName("jubmkxinalebwdxs")
    public suspend fun securityConfig(`value`: Output<FeatureGroupOnlineStoreConfigSecurityConfigArgs>) {
        this.securityConfig = value
    }

    /**
     * @param value Option for different tiers of low latency storage for real-time data retrieval. Valid values are `Standard`, or `InMemory`.
     */
    @JvmName("oahewdafaiocbvkc")
    public suspend fun storageType(`value`: Output<String>) {
        this.storageType = value
    }

    /**
     * @param value Time to live duration, where the record is hard deleted after the expiration time is reached; ExpiresAt = EventTime + TtlDuration.. See TTl Duration Below.
     */
    @JvmName("pvnmqxbsjbnqmfxl")
    public suspend fun ttlDuration(`value`: Output<FeatureGroupOnlineStoreConfigTtlDurationArgs>) {
        this.ttlDuration = value
    }

    /**
     * @param value Set to `true` to disable the automatic creation of an AWS Glue table when configuring an OfflineStore.
     */
    @JvmName("yfnnvupylywkoyow")
    public suspend fun enableOnlineStore(`value`: Boolean?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.enableOnlineStore = mapped
    }

    /**
     * @param value Security config for at-rest encryption of your OnlineStore. See Security Config Below.
     */
    @JvmName("oadommhklgexwylv")
    public suspend fun securityConfig(`value`: FeatureGroupOnlineStoreConfigSecurityConfigArgs?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.securityConfig = mapped
    }

    /**
     * @param argument Security config for at-rest encryption of your OnlineStore. See Security Config Below.
     */
    @JvmName("shdpcfsqqfjwuwhx")
    public suspend fun securityConfig(argument: suspend FeatureGroupOnlineStoreConfigSecurityConfigArgsBuilder.() -> Unit) {
        val toBeMapped = FeatureGroupOnlineStoreConfigSecurityConfigArgsBuilder().applySuspend {
            argument()
        }.build()
        val mapped = of(toBeMapped)
        this.securityConfig = mapped
    }

    /**
     * @param value Option for different tiers of low latency storage for real-time data retrieval. Valid values are `Standard`, or `InMemory`.
     */
    @JvmName("crmcfpeipiehmdoo")
    public suspend fun storageType(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.storageType = mapped
    }

    /**
     * @param value Time to live duration, where the record is hard deleted after the expiration time is reached; ExpiresAt = EventTime + TtlDuration.. See TTl Duration Below.
     */
    @JvmName("viobgyigucybouvw")
    public suspend fun ttlDuration(`value`: FeatureGroupOnlineStoreConfigTtlDurationArgs?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.ttlDuration = mapped
    }

    /**
     * @param argument Time to live duration, where the record is hard deleted after the expiration time is reached; ExpiresAt = EventTime + TtlDuration.. See TTl Duration Below.
     */
    @JvmName("mydnpfatsmaqbjcm")
    public suspend fun ttlDuration(argument: suspend FeatureGroupOnlineStoreConfigTtlDurationArgsBuilder.() -> Unit) {
        val toBeMapped = FeatureGroupOnlineStoreConfigTtlDurationArgsBuilder().applySuspend {
            argument()
        }.build()
        val mapped = of(toBeMapped)
        this.ttlDuration = mapped
    }

    internal fun build(): FeatureGroupOnlineStoreConfigArgs = FeatureGroupOnlineStoreConfigArgs(
        enableOnlineStore = enableOnlineStore,
        securityConfig = securityConfig,
        storageType = storageType,
        ttlDuration = ttlDuration,
    )
}
