@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.sagemaker.kotlin.inputs

import com.pulumi.aws.sagemaker.inputs.FeatureGroupOnlineStoreConfigTtlDurationArgs.builder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.Int
import kotlin.String
import kotlin.Suppress
import kotlin.jvm.JvmName

/**
 *
 * @property unit TtlDuration time unit. Valid values are `Seconds`, `Minutes`, `Hours`, `Days`, or `Weeks`.
 * @property value TtlDuration time value.
 */
public data class FeatureGroupOnlineStoreConfigTtlDurationArgs(
    public val unit: Output<String>? = null,
    public val `value`: Output<Int>? = null,
) : ConvertibleToJava<com.pulumi.aws.sagemaker.inputs.FeatureGroupOnlineStoreConfigTtlDurationArgs> {
    override fun toJava(): com.pulumi.aws.sagemaker.inputs.FeatureGroupOnlineStoreConfigTtlDurationArgs =
        com.pulumi.aws.sagemaker.inputs.FeatureGroupOnlineStoreConfigTtlDurationArgs.builder()
            .unit(unit?.applyValue({ args0 -> args0 }))
            .`value`(`value`?.applyValue({ args0 -> args0 })).build()
}

/**
 * Builder for [FeatureGroupOnlineStoreConfigTtlDurationArgs].
 */
@PulumiTagMarker
public class FeatureGroupOnlineStoreConfigTtlDurationArgsBuilder internal constructor() {
    private var unit: Output<String>? = null

    private var `value`: Output<Int>? = null

    /**
     * @param value TtlDuration time unit. Valid values are `Seconds`, `Minutes`, `Hours`, `Days`, or `Weeks`.
     */
    @JvmName("hteauccsniqbjjxy")
    public suspend fun unit(`value`: Output<String>) {
        this.unit = value
    }

    /**
     * @param value TtlDuration time value.
     */
    @JvmName("nylquyniokimtddu")
    public suspend fun `value`(`value`: Output<Int>) {
        this.`value` = value
    }

    /**
     * @param value TtlDuration time unit. Valid values are `Seconds`, `Minutes`, `Hours`, `Days`, or `Weeks`.
     */
    @JvmName("ibsoigvaqjmawncu")
    public suspend fun unit(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.unit = mapped
    }

    /**
     * @param value TtlDuration time value.
     */
    @JvmName("dahwjnnpecpqnlrk")
    public suspend fun `value`(`value`: Int?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.`value` = mapped
    }

    internal fun build(): FeatureGroupOnlineStoreConfigTtlDurationArgs =
        FeatureGroupOnlineStoreConfigTtlDurationArgs(
            unit = unit,
            `value` = `value`,
        )
}
