@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.sagemaker.kotlin.inputs

import com.pulumi.aws.sagemaker.inputs.FlowDefinitionHumanLoopActivationConfigArgs.builder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.applySuspend
import kotlin.Suppress
import kotlin.Unit
import kotlin.jvm.JvmName

/**
 *
 * @property humanLoopActivationConditionsConfig defines under what conditions SageMaker creates a human loop. See Human Loop Activation Conditions Config details below.
 */
public data class FlowDefinitionHumanLoopActivationConfigArgs(
    public val humanLoopActivationConditionsConfig: Output<FlowDefinitionHumanLoopActivationConfigHumanLoopActivationConditionsConfigArgs>? =
        null,
) : ConvertibleToJava<com.pulumi.aws.sagemaker.inputs.FlowDefinitionHumanLoopActivationConfigArgs> {
    override fun toJava(): com.pulumi.aws.sagemaker.inputs.FlowDefinitionHumanLoopActivationConfigArgs = com.pulumi.aws.sagemaker.inputs.FlowDefinitionHumanLoopActivationConfigArgs.builder()
        .humanLoopActivationConditionsConfig(
            humanLoopActivationConditionsConfig?.applyValue({ args0 ->
                args0.let({ args0 -> args0.toJava() })
            }),
        ).build()
}

/**
 * Builder for [FlowDefinitionHumanLoopActivationConfigArgs].
 */
@PulumiTagMarker
public class FlowDefinitionHumanLoopActivationConfigArgsBuilder internal constructor() {
    private var humanLoopActivationConditionsConfig:
        Output<FlowDefinitionHumanLoopActivationConfigHumanLoopActivationConditionsConfigArgs>? = null

    /**
     * @param value defines under what conditions SageMaker creates a human loop. See Human Loop Activation Conditions Config details below.
     */
    @JvmName("orwjgfsjqyfyaiwo")
    public suspend fun humanLoopActivationConditionsConfig(`value`: Output<FlowDefinitionHumanLoopActivationConfigHumanLoopActivationConditionsConfigArgs>) {
        this.humanLoopActivationConditionsConfig = value
    }

    /**
     * @param value defines under what conditions SageMaker creates a human loop. See Human Loop Activation Conditions Config details below.
     */
    @JvmName("cjikknffwcfrcjnb")
    public suspend fun humanLoopActivationConditionsConfig(`value`: FlowDefinitionHumanLoopActivationConfigHumanLoopActivationConditionsConfigArgs?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.humanLoopActivationConditionsConfig = mapped
    }

    /**
     * @param argument defines under what conditions SageMaker creates a human loop. See Human Loop Activation Conditions Config details below.
     */
    @JvmName("xmyorvudiimkqdkc")
    public suspend fun humanLoopActivationConditionsConfig(argument: suspend FlowDefinitionHumanLoopActivationConfigHumanLoopActivationConditionsConfigArgsBuilder.() -> Unit) {
        val toBeMapped =
            FlowDefinitionHumanLoopActivationConfigHumanLoopActivationConditionsConfigArgsBuilder().applySuspend {
                argument()
            }.build()
        val mapped = of(toBeMapped)
        this.humanLoopActivationConditionsConfig = mapped
    }

    internal fun build(): FlowDefinitionHumanLoopActivationConfigArgs =
        FlowDefinitionHumanLoopActivationConfigArgs(
            humanLoopActivationConditionsConfig = humanLoopActivationConditionsConfig,
        )
}
