@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.sagemaker.kotlin.inputs

import com.pulumi.aws.sagemaker.inputs.FlowDefinitionHumanLoopConfigPublicWorkforceTaskPriceAmountInUsdArgs.builder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.Int
import kotlin.Suppress
import kotlin.jvm.JvmName

/**
 *
 * @property cents The fractional portion, in cents, of the amount. Valid value range between `0` and `99`.
 * @property dollars The whole number of dollars in the amount. Valid value range between `0` and `2`.
 * @property tenthFractionsOfACent Fractions of a cent, in tenths. Valid value range between `0` and `9`.
 */
public data class FlowDefinitionHumanLoopConfigPublicWorkforceTaskPriceAmountInUsdArgs(
    public val cents: Output<Int>? = null,
    public val dollars: Output<Int>? = null,
    public val tenthFractionsOfACent: Output<Int>? = null,
) :
    ConvertibleToJava<com.pulumi.aws.sagemaker.inputs.FlowDefinitionHumanLoopConfigPublicWorkforceTaskPriceAmountInUsdArgs> {
    override fun toJava(): com.pulumi.aws.sagemaker.inputs.FlowDefinitionHumanLoopConfigPublicWorkforceTaskPriceAmountInUsdArgs =
        com.pulumi.aws.sagemaker.inputs.FlowDefinitionHumanLoopConfigPublicWorkforceTaskPriceAmountInUsdArgs.builder()
            .cents(cents?.applyValue({ args0 -> args0 }))
            .dollars(dollars?.applyValue({ args0 -> args0 }))
            .tenthFractionsOfACent(tenthFractionsOfACent?.applyValue({ args0 -> args0 })).build()
}

/**
 * Builder for [FlowDefinitionHumanLoopConfigPublicWorkforceTaskPriceAmountInUsdArgs].
 */
@PulumiTagMarker
public class FlowDefinitionHumanLoopConfigPublicWorkforceTaskPriceAmountInUsdArgsBuilder internal constructor() {
    private var cents: Output<Int>? = null

    private var dollars: Output<Int>? = null

    private var tenthFractionsOfACent: Output<Int>? = null

    /**
     * @param value The fractional portion, in cents, of the amount. Valid value range between `0` and `99`.
     */
    @JvmName("cywmqaepcqrtlgun")
    public suspend fun cents(`value`: Output<Int>) {
        this.cents = value
    }

    /**
     * @param value The whole number of dollars in the amount. Valid value range between `0` and `2`.
     */
    @JvmName("ouxilmevasxmltbk")
    public suspend fun dollars(`value`: Output<Int>) {
        this.dollars = value
    }

    /**
     * @param value Fractions of a cent, in tenths. Valid value range between `0` and `9`.
     */
    @JvmName("gytoccmneucvmqow")
    public suspend fun tenthFractionsOfACent(`value`: Output<Int>) {
        this.tenthFractionsOfACent = value
    }

    /**
     * @param value The fractional portion, in cents, of the amount. Valid value range between `0` and `99`.
     */
    @JvmName("elolninvbyppxtjp")
    public suspend fun cents(`value`: Int?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.cents = mapped
    }

    /**
     * @param value The whole number of dollars in the amount. Valid value range between `0` and `2`.
     */
    @JvmName("hgrujdbysruayxio")
    public suspend fun dollars(`value`: Int?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.dollars = mapped
    }

    /**
     * @param value Fractions of a cent, in tenths. Valid value range between `0` and `9`.
     */
    @JvmName("umfmobjoyrupqaya")
    public suspend fun tenthFractionsOfACent(`value`: Int?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.tenthFractionsOfACent = mapped
    }

    internal fun build(): FlowDefinitionHumanLoopConfigPublicWorkforceTaskPriceAmountInUsdArgs =
        FlowDefinitionHumanLoopConfigPublicWorkforceTaskPriceAmountInUsdArgs(
            cents = cents,
            dollars = dollars,
            tenthFractionsOfACent = tenthFractionsOfACent,
        )
}
