@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.sagemaker.kotlin.inputs

import com.pulumi.aws.sagemaker.inputs.FlowDefinitionHumanLoopRequestSourceArgs.builder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiNullFieldException
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.String
import kotlin.Suppress
import kotlin.jvm.JvmName

/**
 *
 * @property awsManagedHumanLoopRequestSource Specifies whether Amazon Rekognition or Amazon Textract are used as the integration source. Valid values are: `AWS/Rekognition/DetectModerationLabels/Image/V3` and `AWS/Textract/AnalyzeDocument/Forms/V1`.
 */
public data class FlowDefinitionHumanLoopRequestSourceArgs(
    public val awsManagedHumanLoopRequestSource: Output<String>,
) : ConvertibleToJava<com.pulumi.aws.sagemaker.inputs.FlowDefinitionHumanLoopRequestSourceArgs> {
    override fun toJava(): com.pulumi.aws.sagemaker.inputs.FlowDefinitionHumanLoopRequestSourceArgs =
        com.pulumi.aws.sagemaker.inputs.FlowDefinitionHumanLoopRequestSourceArgs.builder()
            .awsManagedHumanLoopRequestSource(
                awsManagedHumanLoopRequestSource.applyValue({ args0 ->
                    args0
                }),
            ).build()
}

/**
 * Builder for [FlowDefinitionHumanLoopRequestSourceArgs].
 */
@PulumiTagMarker
public class FlowDefinitionHumanLoopRequestSourceArgsBuilder internal constructor() {
    private var awsManagedHumanLoopRequestSource: Output<String>? = null

    /**
     * @param value Specifies whether Amazon Rekognition or Amazon Textract are used as the integration source. Valid values are: `AWS/Rekognition/DetectModerationLabels/Image/V3` and `AWS/Textract/AnalyzeDocument/Forms/V1`.
     */
    @JvmName("bmjvbxhltgxltegr")
    public suspend fun awsManagedHumanLoopRequestSource(`value`: Output<String>) {
        this.awsManagedHumanLoopRequestSource = value
    }

    /**
     * @param value Specifies whether Amazon Rekognition or Amazon Textract are used as the integration source. Valid values are: `AWS/Rekognition/DetectModerationLabels/Image/V3` and `AWS/Textract/AnalyzeDocument/Forms/V1`.
     */
    @JvmName("yaoulwtekcjnqpsc")
    public suspend fun awsManagedHumanLoopRequestSource(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.awsManagedHumanLoopRequestSource = mapped
    }

    internal fun build(): FlowDefinitionHumanLoopRequestSourceArgs =
        FlowDefinitionHumanLoopRequestSourceArgs(
            awsManagedHumanLoopRequestSource = awsManagedHumanLoopRequestSource ?: throw
                PulumiNullFieldException("awsManagedHumanLoopRequestSource"),
        )
}
