@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.sagemaker.kotlin.inputs

import com.pulumi.aws.sagemaker.inputs.HumanTaskUIUiTemplateArgs.builder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.String
import kotlin.Suppress
import kotlin.jvm.JvmName

/**
 *
 * @property content The content of the Liquid template for the worker user interface.
 * @property contentSha256 The SHA-256 digest of the contents of the template.
 * @property url The URL for the user interface template.
 */
public data class HumanTaskUIUiTemplateArgs(
    public val content: Output<String>? = null,
    public val contentSha256: Output<String>? = null,
    public val url: Output<String>? = null,
) : ConvertibleToJava<com.pulumi.aws.sagemaker.inputs.HumanTaskUIUiTemplateArgs> {
    override fun toJava(): com.pulumi.aws.sagemaker.inputs.HumanTaskUIUiTemplateArgs =
        com.pulumi.aws.sagemaker.inputs.HumanTaskUIUiTemplateArgs.builder()
            .content(content?.applyValue({ args0 -> args0 }))
            .contentSha256(contentSha256?.applyValue({ args0 -> args0 }))
            .url(url?.applyValue({ args0 -> args0 })).build()
}

/**
 * Builder for [HumanTaskUIUiTemplateArgs].
 */
@PulumiTagMarker
public class HumanTaskUIUiTemplateArgsBuilder internal constructor() {
    private var content: Output<String>? = null

    private var contentSha256: Output<String>? = null

    private var url: Output<String>? = null

    /**
     * @param value The content of the Liquid template for the worker user interface.
     */
    @JvmName("isrwujpcqcvlmelo")
    public suspend fun content(`value`: Output<String>) {
        this.content = value
    }

    /**
     * @param value The SHA-256 digest of the contents of the template.
     */
    @JvmName("jsfygrsmgaabuwbf")
    public suspend fun contentSha256(`value`: Output<String>) {
        this.contentSha256 = value
    }

    /**
     * @param value The URL for the user interface template.
     */
    @JvmName("lfdhafrqfmwmpndr")
    public suspend fun url(`value`: Output<String>) {
        this.url = value
    }

    /**
     * @param value The content of the Liquid template for the worker user interface.
     */
    @JvmName("mkptmnuhvitvwhde")
    public suspend fun content(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.content = mapped
    }

    /**
     * @param value The SHA-256 digest of the contents of the template.
     */
    @JvmName("araktjbcpondkaoj")
    public suspend fun contentSha256(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.contentSha256 = mapped
    }

    /**
     * @param value The URL for the user interface template.
     */
    @JvmName("ryeqvlfjtmpneygj")
    public suspend fun url(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.url = mapped
    }

    internal fun build(): HumanTaskUIUiTemplateArgs = HumanTaskUIUiTemplateArgs(
        content = content,
        contentSha256 = contentSha256,
        url = url,
    )
}
