@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.sagemaker.kotlin.inputs

import com.pulumi.aws.sagemaker.inputs.ModelContainerImageConfigRepositoryAuthConfigArgs.builder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiNullFieldException
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.String
import kotlin.Suppress
import kotlin.jvm.JvmName

/**
 *
 * @property repositoryCredentialsProviderArn The Amazon Resource Name (ARN) of an AWS Lambda function that provides credentials to authenticate to the private Docker registry where your model image is hosted. For information about how to create an AWS Lambda function, see [Create a Lambda function with the console](https://docs.aws.amazon.com/lambda/latest/dg/getting-started-create-function.html) in the _AWS Lambda Developer Guide_.
 */
public data class ModelContainerImageConfigRepositoryAuthConfigArgs(
    public val repositoryCredentialsProviderArn: Output<String>,
) :
    ConvertibleToJava<com.pulumi.aws.sagemaker.inputs.ModelContainerImageConfigRepositoryAuthConfigArgs> {
    override fun toJava(): com.pulumi.aws.sagemaker.inputs.ModelContainerImageConfigRepositoryAuthConfigArgs =
        com.pulumi.aws.sagemaker.inputs.ModelContainerImageConfigRepositoryAuthConfigArgs.builder()
            .repositoryCredentialsProviderArn(
                repositoryCredentialsProviderArn.applyValue({ args0 ->
                    args0
                }),
            ).build()
}

/**
 * Builder for [ModelContainerImageConfigRepositoryAuthConfigArgs].
 */
@PulumiTagMarker
public class ModelContainerImageConfigRepositoryAuthConfigArgsBuilder internal constructor() {
    private var repositoryCredentialsProviderArn: Output<String>? = null

    /**
     * @param value The Amazon Resource Name (ARN) of an AWS Lambda function that provides credentials to authenticate to the private Docker registry where your model image is hosted. For information about how to create an AWS Lambda function, see [Create a Lambda function with the console](https://docs.aws.amazon.com/lambda/latest/dg/getting-started-create-function.html) in the _AWS Lambda Developer Guide_.
     */
    @JvmName("cuwflsqjlwueubhe")
    public suspend fun repositoryCredentialsProviderArn(`value`: Output<String>) {
        this.repositoryCredentialsProviderArn = value
    }

    /**
     * @param value The Amazon Resource Name (ARN) of an AWS Lambda function that provides credentials to authenticate to the private Docker registry where your model image is hosted. For information about how to create an AWS Lambda function, see [Create a Lambda function with the console](https://docs.aws.amazon.com/lambda/latest/dg/getting-started-create-function.html) in the _AWS Lambda Developer Guide_.
     */
    @JvmName("fhkieqarnwrjnfdd")
    public suspend fun repositoryCredentialsProviderArn(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.repositoryCredentialsProviderArn = mapped
    }

    internal fun build(): ModelContainerImageConfigRepositoryAuthConfigArgs =
        ModelContainerImageConfigRepositoryAuthConfigArgs(
            repositoryCredentialsProviderArn = repositoryCredentialsProviderArn ?: throw
                PulumiNullFieldException("repositoryCredentialsProviderArn"),
        )
}
