@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.sagemaker.kotlin.inputs

import com.pulumi.aws.sagemaker.inputs.ModelContainerModelDataSourceArgs.builder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiNullFieldException
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.applySuspend
import kotlin.Suppress
import kotlin.Unit
import kotlin.collections.List
import kotlin.jvm.JvmName

/**
 *
 * @property s3DataSources The S3 location of model data to deploy.
 */
public data class ModelContainerModelDataSourceArgs(
    public val s3DataSources: Output<List<ModelContainerModelDataSourceS3DataSourceArgs>>,
) : ConvertibleToJava<com.pulumi.aws.sagemaker.inputs.ModelContainerModelDataSourceArgs> {
    override fun toJava(): com.pulumi.aws.sagemaker.inputs.ModelContainerModelDataSourceArgs =
        com.pulumi.aws.sagemaker.inputs.ModelContainerModelDataSourceArgs.builder()
            .s3DataSources(
                s3DataSources.applyValue({ args0 ->
                    args0.map({ args0 ->
                        args0.let({ args0 ->
                            args0.toJava()
                        })
                    })
                }),
            ).build()
}

/**
 * Builder for [ModelContainerModelDataSourceArgs].
 */
@PulumiTagMarker
public class ModelContainerModelDataSourceArgsBuilder internal constructor() {
    private var s3DataSources: Output<List<ModelContainerModelDataSourceS3DataSourceArgs>>? = null

    /**
     * @param value The S3 location of model data to deploy.
     */
    @JvmName("jumgawvcayvarxnf")
    public suspend fun s3DataSources(`value`: Output<List<ModelContainerModelDataSourceS3DataSourceArgs>>) {
        this.s3DataSources = value
    }

    @JvmName("weovcstjlnjpatmu")
    public suspend fun s3DataSources(vararg values: Output<ModelContainerModelDataSourceS3DataSourceArgs>) {
        this.s3DataSources = Output.all(values.asList())
    }

    /**
     * @param values The S3 location of model data to deploy.
     */
    @JvmName("ajxkfuioieljhsfu")
    public suspend fun s3DataSources(values: List<Output<ModelContainerModelDataSourceS3DataSourceArgs>>) {
        this.s3DataSources = Output.all(values)
    }

    /**
     * @param value The S3 location of model data to deploy.
     */
    @JvmName("mapqtgcmpbgghjch")
    public suspend fun s3DataSources(`value`: List<ModelContainerModelDataSourceS3DataSourceArgs>) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.s3DataSources = mapped
    }

    /**
     * @param argument The S3 location of model data to deploy.
     */
    @JvmName("qfghhrjqocelhvuj")
    public suspend fun s3DataSources(argument: List<suspend ModelContainerModelDataSourceS3DataSourceArgsBuilder.() -> Unit>) {
        val toBeMapped = argument.toList().map {
            ModelContainerModelDataSourceS3DataSourceArgsBuilder().applySuspend { it() }.build()
        }
        val mapped = of(toBeMapped)
        this.s3DataSources = mapped
    }

    /**
     * @param argument The S3 location of model data to deploy.
     */
    @JvmName("jlougmmmqwriwtgk")
    public suspend fun s3DataSources(vararg argument: suspend ModelContainerModelDataSourceS3DataSourceArgsBuilder.() -> Unit) {
        val toBeMapped = argument.toList().map {
            ModelContainerModelDataSourceS3DataSourceArgsBuilder().applySuspend { it() }.build()
        }
        val mapped = of(toBeMapped)
        this.s3DataSources = mapped
    }

    /**
     * @param argument The S3 location of model data to deploy.
     */
    @JvmName("mgeyuqmodnctmrla")
    public suspend fun s3DataSources(argument: suspend ModelContainerModelDataSourceS3DataSourceArgsBuilder.() -> Unit) {
        val toBeMapped = listOf(
            ModelContainerModelDataSourceS3DataSourceArgsBuilder().applySuspend {
                argument()
            }.build(),
        )
        val mapped = of(toBeMapped)
        this.s3DataSources = mapped
    }

    /**
     * @param values The S3 location of model data to deploy.
     */
    @JvmName("vqydsbilrlwldwdi")
    public suspend fun s3DataSources(vararg values: ModelContainerModelDataSourceS3DataSourceArgs) {
        val toBeMapped = values.toList()
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.s3DataSources = mapped
    }

    internal fun build(): ModelContainerModelDataSourceArgs = ModelContainerModelDataSourceArgs(
        s3DataSources = s3DataSources ?: throw PulumiNullFieldException("s3DataSources"),
    )
}
