@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.sagemaker.kotlin.inputs

import com.pulumi.aws.sagemaker.inputs.ModelInferenceExecutionConfigArgs.builder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiNullFieldException
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.String
import kotlin.Suppress
import kotlin.jvm.JvmName

/**
 *
 * @property mode The container hosts value `SingleModel/MultiModel`. The default value is `SingleModel`.
 */
public data class ModelInferenceExecutionConfigArgs(
    public val mode: Output<String>,
) : ConvertibleToJava<com.pulumi.aws.sagemaker.inputs.ModelInferenceExecutionConfigArgs> {
    override fun toJava(): com.pulumi.aws.sagemaker.inputs.ModelInferenceExecutionConfigArgs =
        com.pulumi.aws.sagemaker.inputs.ModelInferenceExecutionConfigArgs.builder()
            .mode(mode.applyValue({ args0 -> args0 })).build()
}

/**
 * Builder for [ModelInferenceExecutionConfigArgs].
 */
@PulumiTagMarker
public class ModelInferenceExecutionConfigArgsBuilder internal constructor() {
    private var mode: Output<String>? = null

    /**
     * @param value The container hosts value `SingleModel/MultiModel`. The default value is `SingleModel`.
     */
    @JvmName("kjhwqboxopdatadi")
    public suspend fun mode(`value`: Output<String>) {
        this.mode = value
    }

    /**
     * @param value The container hosts value `SingleModel/MultiModel`. The default value is `SingleModel`.
     */
    @JvmName("jrqdhpoghitufubo")
    public suspend fun mode(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.mode = mapped
    }

    internal fun build(): ModelInferenceExecutionConfigArgs = ModelInferenceExecutionConfigArgs(
        mode = mode ?: throw PulumiNullFieldException("mode"),
    )
}
