@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.sagemaker.kotlin.inputs

import com.pulumi.aws.sagemaker.inputs.ModelPrimaryContainerImageConfigArgs.builder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiNullFieldException
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.applySuspend
import kotlin.String
import kotlin.Suppress
import kotlin.Unit
import kotlin.jvm.JvmName

/**
 *
 * @property repositoryAccessMode Specifies whether the model container is in Amazon ECR or a private Docker registry accessible from your Amazon Virtual Private Cloud (VPC). Allowed values are: `Platform` and `Vpc`.
 * @property repositoryAuthConfig Specifies an authentication configuration for the private docker registry where your model image is hosted. Specify a value for this property only if you specified Vpc as the value for the RepositoryAccessMode field, and the private Docker registry where the model image is hosted requires authentication. see Repository Auth Config.
 */
public data class ModelPrimaryContainerImageConfigArgs(
    public val repositoryAccessMode: Output<String>,
    public val repositoryAuthConfig: Output<ModelPrimaryContainerImageConfigRepositoryAuthConfigArgs>? =
        null,
) : ConvertibleToJava<com.pulumi.aws.sagemaker.inputs.ModelPrimaryContainerImageConfigArgs> {
    override fun toJava(): com.pulumi.aws.sagemaker.inputs.ModelPrimaryContainerImageConfigArgs =
        com.pulumi.aws.sagemaker.inputs.ModelPrimaryContainerImageConfigArgs.builder()
            .repositoryAccessMode(repositoryAccessMode.applyValue({ args0 -> args0 }))
            .repositoryAuthConfig(
                repositoryAuthConfig?.applyValue({ args0 ->
                    args0.let({ args0 ->
                        args0.toJava()
                    })
                }),
            ).build()
}

/**
 * Builder for [ModelPrimaryContainerImageConfigArgs].
 */
@PulumiTagMarker
public class ModelPrimaryContainerImageConfigArgsBuilder internal constructor() {
    private var repositoryAccessMode: Output<String>? = null

    private var repositoryAuthConfig:
        Output<ModelPrimaryContainerImageConfigRepositoryAuthConfigArgs>? = null

    /**
     * @param value Specifies whether the model container is in Amazon ECR or a private Docker registry accessible from your Amazon Virtual Private Cloud (VPC). Allowed values are: `Platform` and `Vpc`.
     */
    @JvmName("sgiwasskungohhto")
    public suspend fun repositoryAccessMode(`value`: Output<String>) {
        this.repositoryAccessMode = value
    }

    /**
     * @param value Specifies an authentication configuration for the private docker registry where your model image is hosted. Specify a value for this property only if you specified Vpc as the value for the RepositoryAccessMode field, and the private Docker registry where the model image is hosted requires authentication. see Repository Auth Config.
     */
    @JvmName("tqhevfenmeukxcys")
    public suspend fun repositoryAuthConfig(`value`: Output<ModelPrimaryContainerImageConfigRepositoryAuthConfigArgs>) {
        this.repositoryAuthConfig = value
    }

    /**
     * @param value Specifies whether the model container is in Amazon ECR or a private Docker registry accessible from your Amazon Virtual Private Cloud (VPC). Allowed values are: `Platform` and `Vpc`.
     */
    @JvmName("gifwqcdleqkribfr")
    public suspend fun repositoryAccessMode(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.repositoryAccessMode = mapped
    }

    /**
     * @param value Specifies an authentication configuration for the private docker registry where your model image is hosted. Specify a value for this property only if you specified Vpc as the value for the RepositoryAccessMode field, and the private Docker registry where the model image is hosted requires authentication. see Repository Auth Config.
     */
    @JvmName("trardjhwckqcdwhs")
    public suspend fun repositoryAuthConfig(`value`: ModelPrimaryContainerImageConfigRepositoryAuthConfigArgs?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.repositoryAuthConfig = mapped
    }

    /**
     * @param argument Specifies an authentication configuration for the private docker registry where your model image is hosted. Specify a value for this property only if you specified Vpc as the value for the RepositoryAccessMode field, and the private Docker registry where the model image is hosted requires authentication. see Repository Auth Config.
     */
    @JvmName("voqcenmblyblfsji")
    public suspend fun repositoryAuthConfig(argument: suspend ModelPrimaryContainerImageConfigRepositoryAuthConfigArgsBuilder.() -> Unit) {
        val toBeMapped = ModelPrimaryContainerImageConfigRepositoryAuthConfigArgsBuilder().applySuspend {
            argument()
        }.build()
        val mapped = of(toBeMapped)
        this.repositoryAuthConfig = mapped
    }

    internal fun build(): ModelPrimaryContainerImageConfigArgs = ModelPrimaryContainerImageConfigArgs(
        repositoryAccessMode = repositoryAccessMode ?: throw
            PulumiNullFieldException("repositoryAccessMode"),
        repositoryAuthConfig = repositoryAuthConfig,
    )
}
