@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.sagemaker.kotlin.inputs

import com.pulumi.aws.sagemaker.inputs.ModelPrimaryContainerModelDataSourceArgs.builder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiNullFieldException
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.applySuspend
import kotlin.Suppress
import kotlin.Unit
import kotlin.collections.List
import kotlin.jvm.JvmName

/**
 *
 * @property s3DataSources The S3 location of model data to deploy.
 */
public data class ModelPrimaryContainerModelDataSourceArgs(
    public val s3DataSources: Output<List<ModelPrimaryContainerModelDataSourceS3DataSourceArgs>>,
) : ConvertibleToJava<com.pulumi.aws.sagemaker.inputs.ModelPrimaryContainerModelDataSourceArgs> {
    override fun toJava(): com.pulumi.aws.sagemaker.inputs.ModelPrimaryContainerModelDataSourceArgs =
        com.pulumi.aws.sagemaker.inputs.ModelPrimaryContainerModelDataSourceArgs.builder()
            .s3DataSources(
                s3DataSources.applyValue({ args0 ->
                    args0.map({ args0 ->
                        args0.let({ args0 ->
                            args0.toJava()
                        })
                    })
                }),
            ).build()
}

/**
 * Builder for [ModelPrimaryContainerModelDataSourceArgs].
 */
@PulumiTagMarker
public class ModelPrimaryContainerModelDataSourceArgsBuilder internal constructor() {
    private var s3DataSources: Output<List<ModelPrimaryContainerModelDataSourceS3DataSourceArgs>>? =
        null

    /**
     * @param value The S3 location of model data to deploy.
     */
    @JvmName("fcmgcdgfbdribhif")
    public suspend fun s3DataSources(`value`: Output<List<ModelPrimaryContainerModelDataSourceS3DataSourceArgs>>) {
        this.s3DataSources = value
    }

    @JvmName("rixbekvfpwwpycqt")
    public suspend fun s3DataSources(vararg values: Output<ModelPrimaryContainerModelDataSourceS3DataSourceArgs>) {
        this.s3DataSources = Output.all(values.asList())
    }

    /**
     * @param values The S3 location of model data to deploy.
     */
    @JvmName("pgvdtcrulrnfwutb")
    public suspend fun s3DataSources(values: List<Output<ModelPrimaryContainerModelDataSourceS3DataSourceArgs>>) {
        this.s3DataSources = Output.all(values)
    }

    /**
     * @param value The S3 location of model data to deploy.
     */
    @JvmName("bqtxxuxohsygjcwo")
    public suspend fun s3DataSources(`value`: List<ModelPrimaryContainerModelDataSourceS3DataSourceArgs>) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.s3DataSources = mapped
    }

    /**
     * @param argument The S3 location of model data to deploy.
     */
    @JvmName("fcrteefrkenjhhts")
    public suspend fun s3DataSources(argument: List<suspend ModelPrimaryContainerModelDataSourceS3DataSourceArgsBuilder.() -> Unit>) {
        val toBeMapped = argument.toList().map {
            ModelPrimaryContainerModelDataSourceS3DataSourceArgsBuilder().applySuspend { it() }.build()
        }
        val mapped = of(toBeMapped)
        this.s3DataSources = mapped
    }

    /**
     * @param argument The S3 location of model data to deploy.
     */
    @JvmName("ncbscxbwhccrpwcx")
    public suspend fun s3DataSources(vararg argument: suspend ModelPrimaryContainerModelDataSourceS3DataSourceArgsBuilder.() -> Unit) {
        val toBeMapped = argument.toList().map {
            ModelPrimaryContainerModelDataSourceS3DataSourceArgsBuilder().applySuspend { it() }.build()
        }
        val mapped = of(toBeMapped)
        this.s3DataSources = mapped
    }

    /**
     * @param argument The S3 location of model data to deploy.
     */
    @JvmName("nruqqwbslvmmvwfg")
    public suspend fun s3DataSources(argument: suspend ModelPrimaryContainerModelDataSourceS3DataSourceArgsBuilder.() -> Unit) {
        val toBeMapped =
            listOf(
                ModelPrimaryContainerModelDataSourceS3DataSourceArgsBuilder().applySuspend {
                    argument()
                }.build(),
            )
        val mapped = of(toBeMapped)
        this.s3DataSources = mapped
    }

    /**
     * @param values The S3 location of model data to deploy.
     */
    @JvmName("ptmbqgwrhxdecwax")
    public suspend fun s3DataSources(vararg values: ModelPrimaryContainerModelDataSourceS3DataSourceArgs) {
        val toBeMapped = values.toList()
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.s3DataSources = mapped
    }

    internal fun build(): ModelPrimaryContainerModelDataSourceArgs =
        ModelPrimaryContainerModelDataSourceArgs(
            s3DataSources = s3DataSources ?: throw PulumiNullFieldException("s3DataSources"),
        )
}
