@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.sagemaker.kotlin.inputs

import com.pulumi.aws.sagemaker.inputs.ModelVpcConfigArgs.builder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiNullFieldException
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.String
import kotlin.Suppress
import kotlin.collections.List
import kotlin.jvm.JvmName

/**
 *
 * @property securityGroupIds
 * @property subnets
 */
public data class ModelVpcConfigArgs(
    public val securityGroupIds: Output<List<String>>,
    public val subnets: Output<List<String>>,
) : ConvertibleToJava<com.pulumi.aws.sagemaker.inputs.ModelVpcConfigArgs> {
    override fun toJava(): com.pulumi.aws.sagemaker.inputs.ModelVpcConfigArgs =
        com.pulumi.aws.sagemaker.inputs.ModelVpcConfigArgs.builder()
            .securityGroupIds(securityGroupIds.applyValue({ args0 -> args0.map({ args0 -> args0 }) }))
            .subnets(subnets.applyValue({ args0 -> args0.map({ args0 -> args0 }) })).build()
}

/**
 * Builder for [ModelVpcConfigArgs].
 */
@PulumiTagMarker
public class ModelVpcConfigArgsBuilder internal constructor() {
    private var securityGroupIds: Output<List<String>>? = null

    private var subnets: Output<List<String>>? = null

    /**
     * @param value
     */
    @JvmName("brsubrchfxspmjpw")
    public suspend fun securityGroupIds(`value`: Output<List<String>>) {
        this.securityGroupIds = value
    }

    @JvmName("iothrqavfplexjcq")
    public suspend fun securityGroupIds(vararg values: Output<String>) {
        this.securityGroupIds = Output.all(values.asList())
    }

    /**
     * @param values
     */
    @JvmName("nlygstudjffixyjd")
    public suspend fun securityGroupIds(values: List<Output<String>>) {
        this.securityGroupIds = Output.all(values)
    }

    /**
     * @param value
     */
    @JvmName("uijaciabobnotykk")
    public suspend fun subnets(`value`: Output<List<String>>) {
        this.subnets = value
    }

    @JvmName("ymwdwesuoayjswum")
    public suspend fun subnets(vararg values: Output<String>) {
        this.subnets = Output.all(values.asList())
    }

    /**
     * @param values
     */
    @JvmName("efmxujfhrnaevevi")
    public suspend fun subnets(values: List<Output<String>>) {
        this.subnets = Output.all(values)
    }

    /**
     * @param value
     */
    @JvmName("ginjojfgkrpacyct")
    public suspend fun securityGroupIds(`value`: List<String>) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.securityGroupIds = mapped
    }

    /**
     * @param values
     */
    @JvmName("rvjlsfmocaeipsdj")
    public suspend fun securityGroupIds(vararg values: String) {
        val toBeMapped = values.toList()
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.securityGroupIds = mapped
    }

    /**
     * @param value
     */
    @JvmName("oakoyrvggasrvscx")
    public suspend fun subnets(`value`: List<String>) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.subnets = mapped
    }

    /**
     * @param values
     */
    @JvmName("gfkfxswbxocctlil")
    public suspend fun subnets(vararg values: String) {
        val toBeMapped = values.toList()
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.subnets = mapped
    }

    internal fun build(): ModelVpcConfigArgs = ModelVpcConfigArgs(
        securityGroupIds = securityGroupIds ?: throw PulumiNullFieldException("securityGroupIds"),
        subnets = subnets ?: throw PulumiNullFieldException("subnets"),
    )
}
