@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.sagemaker.kotlin.inputs

import com.pulumi.aws.sagemaker.inputs.MonitoringScheduleMonitoringScheduleConfigScheduleConfigArgs.builder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiNullFieldException
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.String
import kotlin.Suppress
import kotlin.jvm.JvmName

/**
 *
 * @property scheduleExpression A cron expression that describes details about the monitoring schedule. For example, and hourly schedule would be `cron(0 * ? * * *)`.
 */
public data class MonitoringScheduleMonitoringScheduleConfigScheduleConfigArgs(
    public val scheduleExpression: Output<String>,
) :
    ConvertibleToJava<com.pulumi.aws.sagemaker.inputs.MonitoringScheduleMonitoringScheduleConfigScheduleConfigArgs> {
    override fun toJava(): com.pulumi.aws.sagemaker.inputs.MonitoringScheduleMonitoringScheduleConfigScheduleConfigArgs =
        com.pulumi.aws.sagemaker.inputs.MonitoringScheduleMonitoringScheduleConfigScheduleConfigArgs.builder()
            .scheduleExpression(scheduleExpression.applyValue({ args0 -> args0 })).build()
}

/**
 * Builder for [MonitoringScheduleMonitoringScheduleConfigScheduleConfigArgs].
 */
@PulumiTagMarker
public class MonitoringScheduleMonitoringScheduleConfigScheduleConfigArgsBuilder internal constructor() {
    private var scheduleExpression: Output<String>? = null

    /**
     * @param value A cron expression that describes details about the monitoring schedule. For example, and hourly schedule would be `cron(0 * ? * * *)`.
     */
    @JvmName("thlslvmmtwiyyyej")
    public suspend fun scheduleExpression(`value`: Output<String>) {
        this.scheduleExpression = value
    }

    /**
     * @param value A cron expression that describes details about the monitoring schedule. For example, and hourly schedule would be `cron(0 * ? * * *)`.
     */
    @JvmName("dplvowiogmtmjebd")
    public suspend fun scheduleExpression(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.scheduleExpression = mapped
    }

    internal fun build(): MonitoringScheduleMonitoringScheduleConfigScheduleConfigArgs =
        MonitoringScheduleMonitoringScheduleConfigScheduleConfigArgs(
            scheduleExpression = scheduleExpression ?: throw PulumiNullFieldException("scheduleExpression"),
        )
}
