@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.sagemaker.kotlin.inputs

import com.pulumi.aws.sagemaker.inputs.NotebookInstanceInstanceMetadataServiceConfigurationArgs.builder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.String
import kotlin.Suppress
import kotlin.jvm.JvmName

/**
 *
 * @property minimumInstanceMetadataServiceVersion Indicates the minimum IMDS version that the notebook instance supports. When passed "1" is passed. This means that both IMDSv1 and IMDSv2 are supported. Valid values are `1` and `2`.
 */
public data class NotebookInstanceInstanceMetadataServiceConfigurationArgs(
    public val minimumInstanceMetadataServiceVersion: Output<String>? = null,
) :
    ConvertibleToJava<com.pulumi.aws.sagemaker.inputs.NotebookInstanceInstanceMetadataServiceConfigurationArgs> {
    override fun toJava(): com.pulumi.aws.sagemaker.inputs.NotebookInstanceInstanceMetadataServiceConfigurationArgs =
        com.pulumi.aws.sagemaker.inputs.NotebookInstanceInstanceMetadataServiceConfigurationArgs.builder()
            .minimumInstanceMetadataServiceVersion(
                minimumInstanceMetadataServiceVersion?.applyValue({ args0 ->
                    args0
                }),
            ).build()
}

/**
 * Builder for [NotebookInstanceInstanceMetadataServiceConfigurationArgs].
 */
@PulumiTagMarker
public class NotebookInstanceInstanceMetadataServiceConfigurationArgsBuilder internal constructor() {
    private var minimumInstanceMetadataServiceVersion: Output<String>? = null

    /**
     * @param value Indicates the minimum IMDS version that the notebook instance supports. When passed "1" is passed. This means that both IMDSv1 and IMDSv2 are supported. Valid values are `1` and `2`.
     */
    @JvmName("nwemkwenbflcsnpb")
    public suspend fun minimumInstanceMetadataServiceVersion(`value`: Output<String>) {
        this.minimumInstanceMetadataServiceVersion = value
    }

    /**
     * @param value Indicates the minimum IMDS version that the notebook instance supports. When passed "1" is passed. This means that both IMDSv1 and IMDSv2 are supported. Valid values are `1` and `2`.
     */
    @JvmName("lokvqlmfaptkbdfg")
    public suspend fun minimumInstanceMetadataServiceVersion(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.minimumInstanceMetadataServiceVersion = mapped
    }

    internal fun build(): NotebookInstanceInstanceMetadataServiceConfigurationArgs =
        NotebookInstanceInstanceMetadataServiceConfigurationArgs(
            minimumInstanceMetadataServiceVersion = minimumInstanceMetadataServiceVersion,
        )
}
