@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.sagemaker.kotlin.inputs

import com.pulumi.aws.sagemaker.inputs.ProjectServiceCatalogProvisioningDetailsArgs.builder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiNullFieldException
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.applySuspend
import kotlin.String
import kotlin.Suppress
import kotlin.Unit
import kotlin.collections.List
import kotlin.jvm.JvmName

/**
 *
 * @property pathId The path identifier of the product. This value is optional if the product has a default path, and required if the product has more than one path.
 * @property productId The ID of the product to provision.
 * @property provisioningArtifactId The ID of the provisioning artifact.
 * @property provisioningParameters A list of key value pairs that you specify when you provision a product. See Provisioning Parameter below.
 */
public data class ProjectServiceCatalogProvisioningDetailsArgs(
    public val pathId: Output<String>? = null,
    public val productId: Output<String>,
    public val provisioningArtifactId: Output<String>? = null,
    public val provisioningParameters: Output<List<ProjectServiceCatalogProvisioningDetailsProvisioningParameterArgs>>? = null,
) : ConvertibleToJava<com.pulumi.aws.sagemaker.inputs.ProjectServiceCatalogProvisioningDetailsArgs> {
    override fun toJava(): com.pulumi.aws.sagemaker.inputs.ProjectServiceCatalogProvisioningDetailsArgs =
        com.pulumi.aws.sagemaker.inputs.ProjectServiceCatalogProvisioningDetailsArgs.builder()
            .pathId(pathId?.applyValue({ args0 -> args0 }))
            .productId(productId.applyValue({ args0 -> args0 }))
            .provisioningArtifactId(provisioningArtifactId?.applyValue({ args0 -> args0 }))
            .provisioningParameters(
                provisioningParameters?.applyValue({ args0 ->
                    args0.map({ args0 ->
                        args0.let({ args0 -> args0.toJava() })
                    })
                }),
            ).build()
}

/**
 * Builder for [ProjectServiceCatalogProvisioningDetailsArgs].
 */
@PulumiTagMarker
public class ProjectServiceCatalogProvisioningDetailsArgsBuilder internal constructor() {
    private var pathId: Output<String>? = null

    private var productId: Output<String>? = null

    private var provisioningArtifactId: Output<String>? = null

    private var provisioningParameters:
        Output<List<ProjectServiceCatalogProvisioningDetailsProvisioningParameterArgs>>? = null

    /**
     * @param value The path identifier of the product. This value is optional if the product has a default path, and required if the product has more than one path.
     */
    @JvmName("rvggrkcftlscbaua")
    public suspend fun pathId(`value`: Output<String>) {
        this.pathId = value
    }

    /**
     * @param value The ID of the product to provision.
     */
    @JvmName("hkmleceqhcyjhpfh")
    public suspend fun productId(`value`: Output<String>) {
        this.productId = value
    }

    /**
     * @param value The ID of the provisioning artifact.
     */
    @JvmName("pnrtswuisgqnagya")
    public suspend fun provisioningArtifactId(`value`: Output<String>) {
        this.provisioningArtifactId = value
    }

    /**
     * @param value A list of key value pairs that you specify when you provision a product. See Provisioning Parameter below.
     */
    @JvmName("dasgdgujvyybqyoa")
    public suspend fun provisioningParameters(`value`: Output<List<ProjectServiceCatalogProvisioningDetailsProvisioningParameterArgs>>) {
        this.provisioningParameters = value
    }

    @JvmName("icairyutfyfyqgcs")
    public suspend fun provisioningParameters(vararg values: Output<ProjectServiceCatalogProvisioningDetailsProvisioningParameterArgs>) {
        this.provisioningParameters = Output.all(values.asList())
    }

    /**
     * @param values A list of key value pairs that you specify when you provision a product. See Provisioning Parameter below.
     */
    @JvmName("bcrfmeujqauqenbx")
    public suspend fun provisioningParameters(values: List<Output<ProjectServiceCatalogProvisioningDetailsProvisioningParameterArgs>>) {
        this.provisioningParameters = Output.all(values)
    }

    /**
     * @param value The path identifier of the product. This value is optional if the product has a default path, and required if the product has more than one path.
     */
    @JvmName("bwqaivkynelfkklr")
    public suspend fun pathId(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.pathId = mapped
    }

    /**
     * @param value The ID of the product to provision.
     */
    @JvmName("vqeexjvpgdfbgytk")
    public suspend fun productId(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.productId = mapped
    }

    /**
     * @param value The ID of the provisioning artifact.
     */
    @JvmName("wwpiedxremjqhdfa")
    public suspend fun provisioningArtifactId(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.provisioningArtifactId = mapped
    }

    /**
     * @param value A list of key value pairs that you specify when you provision a product. See Provisioning Parameter below.
     */
    @JvmName("seayljuneggjhifr")
    public suspend fun provisioningParameters(`value`: List<ProjectServiceCatalogProvisioningDetailsProvisioningParameterArgs>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.provisioningParameters = mapped
    }

    /**
     * @param argument A list of key value pairs that you specify when you provision a product. See Provisioning Parameter below.
     */
    @JvmName("hrfeimpmlklhahyr")
    public suspend fun provisioningParameters(argument: List<suspend ProjectServiceCatalogProvisioningDetailsProvisioningParameterArgsBuilder.() -> Unit>) {
        val toBeMapped = argument.toList().map {
            ProjectServiceCatalogProvisioningDetailsProvisioningParameterArgsBuilder().applySuspend {
                it()
            }.build()
        }
        val mapped = of(toBeMapped)
        this.provisioningParameters = mapped
    }

    /**
     * @param argument A list of key value pairs that you specify when you provision a product. See Provisioning Parameter below.
     */
    @JvmName("mkkqssgdspgisehb")
    public suspend fun provisioningParameters(vararg argument: suspend ProjectServiceCatalogProvisioningDetailsProvisioningParameterArgsBuilder.() -> Unit) {
        val toBeMapped = argument.toList().map {
            ProjectServiceCatalogProvisioningDetailsProvisioningParameterArgsBuilder().applySuspend {
                it()
            }.build()
        }
        val mapped = of(toBeMapped)
        this.provisioningParameters = mapped
    }

    /**
     * @param argument A list of key value pairs that you specify when you provision a product. See Provisioning Parameter below.
     */
    @JvmName("jkcrldbinebiabkf")
    public suspend fun provisioningParameters(argument: suspend ProjectServiceCatalogProvisioningDetailsProvisioningParameterArgsBuilder.() -> Unit) {
        val toBeMapped =
            listOf(
                ProjectServiceCatalogProvisioningDetailsProvisioningParameterArgsBuilder().applySuspend
                    { argument() }.build(),
            )
        val mapped = of(toBeMapped)
        this.provisioningParameters = mapped
    }

    /**
     * @param values A list of key value pairs that you specify when you provision a product. See Provisioning Parameter below.
     */
    @JvmName("obgoabquantxoxed")
    public suspend fun provisioningParameters(vararg values: ProjectServiceCatalogProvisioningDetailsProvisioningParameterArgs) {
        val toBeMapped = values.toList()
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.provisioningParameters = mapped
    }

    internal fun build(): ProjectServiceCatalogProvisioningDetailsArgs =
        ProjectServiceCatalogProvisioningDetailsArgs(
            pathId = pathId,
            productId = productId ?: throw PulumiNullFieldException("productId"),
            provisioningArtifactId = provisioningArtifactId,
            provisioningParameters = provisioningParameters,
        )
}
