@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.sagemaker.kotlin.inputs

import com.pulumi.aws.sagemaker.inputs.ProjectServiceCatalogProvisioningDetailsProvisioningParameterArgs.builder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiNullFieldException
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.String
import kotlin.Suppress
import kotlin.jvm.JvmName

/**
 *
 * @property key The key that identifies a provisioning parameter.
 * @property value The value of the provisioning parameter.
 */
public data class ProjectServiceCatalogProvisioningDetailsProvisioningParameterArgs(
    public val key: Output<String>,
    public val `value`: Output<String>? = null,
) :
    ConvertibleToJava<com.pulumi.aws.sagemaker.inputs.ProjectServiceCatalogProvisioningDetailsProvisioningParameterArgs> {
    override fun toJava(): com.pulumi.aws.sagemaker.inputs.ProjectServiceCatalogProvisioningDetailsProvisioningParameterArgs =
        com.pulumi.aws.sagemaker.inputs.ProjectServiceCatalogProvisioningDetailsProvisioningParameterArgs.builder()
            .key(key.applyValue({ args0 -> args0 }))
            .`value`(`value`?.applyValue({ args0 -> args0 })).build()
}

/**
 * Builder for [ProjectServiceCatalogProvisioningDetailsProvisioningParameterArgs].
 */
@PulumiTagMarker
public class ProjectServiceCatalogProvisioningDetailsProvisioningParameterArgsBuilder internal constructor() {
    private var key: Output<String>? = null

    private var `value`: Output<String>? = null

    /**
     * @param value The key that identifies a provisioning parameter.
     */
    @JvmName("cmgbxltskjspkluq")
    public suspend fun key(`value`: Output<String>) {
        this.key = value
    }

    /**
     * @param value The value of the provisioning parameter.
     */
    @JvmName("ybfkixkloisehboy")
    public suspend fun `value`(`value`: Output<String>) {
        this.`value` = value
    }

    /**
     * @param value The key that identifies a provisioning parameter.
     */
    @JvmName("qpvknevyrpwrmpjm")
    public suspend fun key(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.key = mapped
    }

    /**
     * @param value The value of the provisioning parameter.
     */
    @JvmName("rdcaaqrqsvkoyiqa")
    public suspend fun `value`(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.`value` = mapped
    }

    internal fun build(): ProjectServiceCatalogProvisioningDetailsProvisioningParameterArgs =
        ProjectServiceCatalogProvisioningDetailsProvisioningParameterArgs(
            key = key ?: throw PulumiNullFieldException("key"),
            `value` = `value`,
        )
}
