@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.sagemaker.kotlin.inputs

import com.pulumi.aws.sagemaker.inputs.SpaceOwnershipSettingsArgs.builder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiNullFieldException
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.String
import kotlin.Suppress
import kotlin.jvm.JvmName

/**
 *
 * @property ownerUserProfileName The user profile who is the owner of the private space.
 */
public data class SpaceOwnershipSettingsArgs(
    public val ownerUserProfileName: Output<String>,
) : ConvertibleToJava<com.pulumi.aws.sagemaker.inputs.SpaceOwnershipSettingsArgs> {
    override fun toJava(): com.pulumi.aws.sagemaker.inputs.SpaceOwnershipSettingsArgs =
        com.pulumi.aws.sagemaker.inputs.SpaceOwnershipSettingsArgs.builder()
            .ownerUserProfileName(ownerUserProfileName.applyValue({ args0 -> args0 })).build()
}

/**
 * Builder for [SpaceOwnershipSettingsArgs].
 */
@PulumiTagMarker
public class SpaceOwnershipSettingsArgsBuilder internal constructor() {
    private var ownerUserProfileName: Output<String>? = null

    /**
     * @param value The user profile who is the owner of the private space.
     */
    @JvmName("ahirhkimduruvqhr")
    public suspend fun ownerUserProfileName(`value`: Output<String>) {
        this.ownerUserProfileName = value
    }

    /**
     * @param value The user profile who is the owner of the private space.
     */
    @JvmName("riopotqmwpxgxpor")
    public suspend fun ownerUserProfileName(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.ownerUserProfileName = mapped
    }

    internal fun build(): SpaceOwnershipSettingsArgs = SpaceOwnershipSettingsArgs(
        ownerUserProfileName = ownerUserProfileName ?: throw
            PulumiNullFieldException("ownerUserProfileName"),
    )
}
