@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.sagemaker.kotlin.inputs

import com.pulumi.aws.sagemaker.inputs.SpaceSpaceSettingsArgs.builder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.applySuspend
import kotlin.String
import kotlin.Suppress
import kotlin.Unit
import kotlin.collections.List
import kotlin.jvm.JvmName

/**
 *
 * @property appType The type of app created within the space.
 * @property codeEditorAppSettings The Code Editor application settings. See `code_editor_app_settings` Block below.
 * @property customFileSystems A file system, created by you, that you assign to a space for an Amazon SageMaker Domain. See `custom_file_system` Block below.
 * @property jupyterLabAppSettings The settings for the JupyterLab application. See `jupyter_lab_app_settings` Block below.
 * @property jupyterServerAppSettings The Jupyter server's app settings. See `jupyter_server_app_settings` Block below.
 * @property kernelGatewayAppSettings The kernel gateway app settings. See `kernel_gateway_app_settings` Block below.
 * @property spaceStorageSettings The storage settings. See `space_storage_settings` Block below.
 */
public data class SpaceSpaceSettingsArgs(
    public val appType: Output<String>? = null,
    public val codeEditorAppSettings: Output<SpaceSpaceSettingsCodeEditorAppSettingsArgs>? = null,
    public val customFileSystems: Output<List<SpaceSpaceSettingsCustomFileSystemArgs>>? = null,
    public val jupyterLabAppSettings: Output<SpaceSpaceSettingsJupyterLabAppSettingsArgs>? = null,
    public val jupyterServerAppSettings: Output<SpaceSpaceSettingsJupyterServerAppSettingsArgs>? =
        null,
    public val kernelGatewayAppSettings: Output<SpaceSpaceSettingsKernelGatewayAppSettingsArgs>? =
        null,
    public val spaceStorageSettings: Output<SpaceSpaceSettingsSpaceStorageSettingsArgs>? = null,
) : ConvertibleToJava<com.pulumi.aws.sagemaker.inputs.SpaceSpaceSettingsArgs> {
    override fun toJava(): com.pulumi.aws.sagemaker.inputs.SpaceSpaceSettingsArgs =
        com.pulumi.aws.sagemaker.inputs.SpaceSpaceSettingsArgs.builder()
            .appType(appType?.applyValue({ args0 -> args0 }))
            .codeEditorAppSettings(
                codeEditorAppSettings?.applyValue({ args0 ->
                    args0.let({ args0 ->
                        args0.toJava()
                    })
                }),
            )
            .customFileSystems(
                customFileSystems?.applyValue({ args0 ->
                    args0.map({ args0 ->
                        args0.let({ args0 ->
                            args0.toJava()
                        })
                    })
                }),
            )
            .jupyterLabAppSettings(
                jupyterLabAppSettings?.applyValue({ args0 ->
                    args0.let({ args0 ->
                        args0.toJava()
                    })
                }),
            )
            .jupyterServerAppSettings(
                jupyterServerAppSettings?.applyValue({ args0 ->
                    args0.let({ args0 ->
                        args0.toJava()
                    })
                }),
            )
            .kernelGatewayAppSettings(
                kernelGatewayAppSettings?.applyValue({ args0 ->
                    args0.let({ args0 ->
                        args0.toJava()
                    })
                }),
            )
            .spaceStorageSettings(
                spaceStorageSettings?.applyValue({ args0 ->
                    args0.let({ args0 ->
                        args0.toJava()
                    })
                }),
            ).build()
}

/**
 * Builder for [SpaceSpaceSettingsArgs].
 */
@PulumiTagMarker
public class SpaceSpaceSettingsArgsBuilder internal constructor() {
    private var appType: Output<String>? = null

    private var codeEditorAppSettings: Output<SpaceSpaceSettingsCodeEditorAppSettingsArgs>? = null

    private var customFileSystems: Output<List<SpaceSpaceSettingsCustomFileSystemArgs>>? = null

    private var jupyterLabAppSettings: Output<SpaceSpaceSettingsJupyterLabAppSettingsArgs>? = null

    private var jupyterServerAppSettings: Output<SpaceSpaceSettingsJupyterServerAppSettingsArgs>? =
        null

    private var kernelGatewayAppSettings: Output<SpaceSpaceSettingsKernelGatewayAppSettingsArgs>? =
        null

    private var spaceStorageSettings: Output<SpaceSpaceSettingsSpaceStorageSettingsArgs>? = null

    /**
     * @param value The type of app created within the space.
     */
    @JvmName("yrypwtsyveyuiplk")
    public suspend fun appType(`value`: Output<String>) {
        this.appType = value
    }

    /**
     * @param value The Code Editor application settings. See `code_editor_app_settings` Block below.
     */
    @JvmName("giyawgiknwsaabwj")
    public suspend fun codeEditorAppSettings(`value`: Output<SpaceSpaceSettingsCodeEditorAppSettingsArgs>) {
        this.codeEditorAppSettings = value
    }

    /**
     * @param value A file system, created by you, that you assign to a space for an Amazon SageMaker Domain. See `custom_file_system` Block below.
     */
    @JvmName("wmjdofibrcnepnhr")
    public suspend fun customFileSystems(`value`: Output<List<SpaceSpaceSettingsCustomFileSystemArgs>>) {
        this.customFileSystems = value
    }

    @JvmName("koenbrdflymusdch")
    public suspend fun customFileSystems(vararg values: Output<SpaceSpaceSettingsCustomFileSystemArgs>) {
        this.customFileSystems = Output.all(values.asList())
    }

    /**
     * @param values A file system, created by you, that you assign to a space for an Amazon SageMaker Domain. See `custom_file_system` Block below.
     */
    @JvmName("gwxvukiehhtnwbhj")
    public suspend fun customFileSystems(values: List<Output<SpaceSpaceSettingsCustomFileSystemArgs>>) {
        this.customFileSystems = Output.all(values)
    }

    /**
     * @param value The settings for the JupyterLab application. See `jupyter_lab_app_settings` Block below.
     */
    @JvmName("effjkwjqotflfobf")
    public suspend fun jupyterLabAppSettings(`value`: Output<SpaceSpaceSettingsJupyterLabAppSettingsArgs>) {
        this.jupyterLabAppSettings = value
    }

    /**
     * @param value The Jupyter server's app settings. See `jupyter_server_app_settings` Block below.
     */
    @JvmName("xwwjycjxfaqpfdlf")
    public suspend fun jupyterServerAppSettings(`value`: Output<SpaceSpaceSettingsJupyterServerAppSettingsArgs>) {
        this.jupyterServerAppSettings = value
    }

    /**
     * @param value The kernel gateway app settings. See `kernel_gateway_app_settings` Block below.
     */
    @JvmName("emcrysowoyyctoly")
    public suspend fun kernelGatewayAppSettings(`value`: Output<SpaceSpaceSettingsKernelGatewayAppSettingsArgs>) {
        this.kernelGatewayAppSettings = value
    }

    /**
     * @param value The storage settings. See `space_storage_settings` Block below.
     */
    @JvmName("enyobupbfadmbhtw")
    public suspend fun spaceStorageSettings(`value`: Output<SpaceSpaceSettingsSpaceStorageSettingsArgs>) {
        this.spaceStorageSettings = value
    }

    /**
     * @param value The type of app created within the space.
     */
    @JvmName("cddrcklefeksnoqw")
    public suspend fun appType(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.appType = mapped
    }

    /**
     * @param value The Code Editor application settings. See `code_editor_app_settings` Block below.
     */
    @JvmName("jhcvmfrisdfuwvnt")
    public suspend fun codeEditorAppSettings(`value`: SpaceSpaceSettingsCodeEditorAppSettingsArgs?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.codeEditorAppSettings = mapped
    }

    /**
     * @param argument The Code Editor application settings. See `code_editor_app_settings` Block below.
     */
    @JvmName("vvuhbyhvsvwnmuyd")
    public suspend fun codeEditorAppSettings(argument: suspend SpaceSpaceSettingsCodeEditorAppSettingsArgsBuilder.() -> Unit) {
        val toBeMapped = SpaceSpaceSettingsCodeEditorAppSettingsArgsBuilder().applySuspend {
            argument()
        }.build()
        val mapped = of(toBeMapped)
        this.codeEditorAppSettings = mapped
    }

    /**
     * @param value A file system, created by you, that you assign to a space for an Amazon SageMaker Domain. See `custom_file_system` Block below.
     */
    @JvmName("tviypafvxmoglwhb")
    public suspend fun customFileSystems(`value`: List<SpaceSpaceSettingsCustomFileSystemArgs>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.customFileSystems = mapped
    }

    /**
     * @param argument A file system, created by you, that you assign to a space for an Amazon SageMaker Domain. See `custom_file_system` Block below.
     */
    @JvmName("oxxfcjdhwxfschlx")
    public suspend fun customFileSystems(argument: List<suspend SpaceSpaceSettingsCustomFileSystemArgsBuilder.() -> Unit>) {
        val toBeMapped = argument.toList().map {
            SpaceSpaceSettingsCustomFileSystemArgsBuilder().applySuspend { it() }.build()
        }
        val mapped = of(toBeMapped)
        this.customFileSystems = mapped
    }

    /**
     * @param argument A file system, created by you, that you assign to a space for an Amazon SageMaker Domain. See `custom_file_system` Block below.
     */
    @JvmName("wtljvhnpuubfgoku")
    public suspend fun customFileSystems(vararg argument: suspend SpaceSpaceSettingsCustomFileSystemArgsBuilder.() -> Unit) {
        val toBeMapped = argument.toList().map {
            SpaceSpaceSettingsCustomFileSystemArgsBuilder().applySuspend { it() }.build()
        }
        val mapped = of(toBeMapped)
        this.customFileSystems = mapped
    }

    /**
     * @param argument A file system, created by you, that you assign to a space for an Amazon SageMaker Domain. See `custom_file_system` Block below.
     */
    @JvmName("emdjtoyqkshjmgqv")
    public suspend fun customFileSystems(argument: suspend SpaceSpaceSettingsCustomFileSystemArgsBuilder.() -> Unit) {
        val toBeMapped = listOf(
            SpaceSpaceSettingsCustomFileSystemArgsBuilder().applySuspend {
                argument()
            }.build(),
        )
        val mapped = of(toBeMapped)
        this.customFileSystems = mapped
    }

    /**
     * @param values A file system, created by you, that you assign to a space for an Amazon SageMaker Domain. See `custom_file_system` Block below.
     */
    @JvmName("xgkdgckknwihkmwn")
    public suspend fun customFileSystems(vararg values: SpaceSpaceSettingsCustomFileSystemArgs) {
        val toBeMapped = values.toList()
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.customFileSystems = mapped
    }

    /**
     * @param value The settings for the JupyterLab application. See `jupyter_lab_app_settings` Block below.
     */
    @JvmName("tevbbygjnpcmakot")
    public suspend fun jupyterLabAppSettings(`value`: SpaceSpaceSettingsJupyterLabAppSettingsArgs?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.jupyterLabAppSettings = mapped
    }

    /**
     * @param argument The settings for the JupyterLab application. See `jupyter_lab_app_settings` Block below.
     */
    @JvmName("ijnskeahfetaropd")
    public suspend fun jupyterLabAppSettings(argument: suspend SpaceSpaceSettingsJupyterLabAppSettingsArgsBuilder.() -> Unit) {
        val toBeMapped = SpaceSpaceSettingsJupyterLabAppSettingsArgsBuilder().applySuspend {
            argument()
        }.build()
        val mapped = of(toBeMapped)
        this.jupyterLabAppSettings = mapped
    }

    /**
     * @param value The Jupyter server's app settings. See `jupyter_server_app_settings` Block below.
     */
    @JvmName("avtstxmjtfdwwoni")
    public suspend fun jupyterServerAppSettings(`value`: SpaceSpaceSettingsJupyterServerAppSettingsArgs?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.jupyterServerAppSettings = mapped
    }

    /**
     * @param argument The Jupyter server's app settings. See `jupyter_server_app_settings` Block below.
     */
    @JvmName("ffrvwbhjrpcnukyo")
    public suspend fun jupyterServerAppSettings(argument: suspend SpaceSpaceSettingsJupyterServerAppSettingsArgsBuilder.() -> Unit) {
        val toBeMapped = SpaceSpaceSettingsJupyterServerAppSettingsArgsBuilder().applySuspend {
            argument()
        }.build()
        val mapped = of(toBeMapped)
        this.jupyterServerAppSettings = mapped
    }

    /**
     * @param value The kernel gateway app settings. See `kernel_gateway_app_settings` Block below.
     */
    @JvmName("ykdtakbmqvlvutdm")
    public suspend fun kernelGatewayAppSettings(`value`: SpaceSpaceSettingsKernelGatewayAppSettingsArgs?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.kernelGatewayAppSettings = mapped
    }

    /**
     * @param argument The kernel gateway app settings. See `kernel_gateway_app_settings` Block below.
     */
    @JvmName("jejttkdfwkdthept")
    public suspend fun kernelGatewayAppSettings(argument: suspend SpaceSpaceSettingsKernelGatewayAppSettingsArgsBuilder.() -> Unit) {
        val toBeMapped = SpaceSpaceSettingsKernelGatewayAppSettingsArgsBuilder().applySuspend {
            argument()
        }.build()
        val mapped = of(toBeMapped)
        this.kernelGatewayAppSettings = mapped
    }

    /**
     * @param value The storage settings. See `space_storage_settings` Block below.
     */
    @JvmName("uvbqdpgtwjjpdoiu")
    public suspend fun spaceStorageSettings(`value`: SpaceSpaceSettingsSpaceStorageSettingsArgs?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.spaceStorageSettings = mapped
    }

    /**
     * @param argument The storage settings. See `space_storage_settings` Block below.
     */
    @JvmName("asafwchbpaewncrp")
    public suspend fun spaceStorageSettings(argument: suspend SpaceSpaceSettingsSpaceStorageSettingsArgsBuilder.() -> Unit) {
        val toBeMapped = SpaceSpaceSettingsSpaceStorageSettingsArgsBuilder().applySuspend {
            argument()
        }.build()
        val mapped = of(toBeMapped)
        this.spaceStorageSettings = mapped
    }

    internal fun build(): SpaceSpaceSettingsArgs = SpaceSpaceSettingsArgs(
        appType = appType,
        codeEditorAppSettings = codeEditorAppSettings,
        customFileSystems = customFileSystems,
        jupyterLabAppSettings = jupyterLabAppSettings,
        jupyterServerAppSettings = jupyterServerAppSettings,
        kernelGatewayAppSettings = kernelGatewayAppSettings,
        spaceStorageSettings = spaceStorageSettings,
    )
}
