@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.sagemaker.kotlin.inputs

import com.pulumi.aws.sagemaker.inputs.SpaceSpaceSettingsCodeEditorAppSettingsArgs.builder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiNullFieldException
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.applySuspend
import kotlin.Suppress
import kotlin.Unit
import kotlin.jvm.JvmName

/**
 *
 * @property defaultResourceSpec The default instance type and the Amazon Resource Name (ARN) of the SageMaker image created on the instance. See `default_resource_spec` Block below.
 */
public data class SpaceSpaceSettingsCodeEditorAppSettingsArgs(
    public val defaultResourceSpec: Output<SpaceSpaceSettingsCodeEditorAppSettingsDefaultResourceSpecArgs>,
) : ConvertibleToJava<com.pulumi.aws.sagemaker.inputs.SpaceSpaceSettingsCodeEditorAppSettingsArgs> {
    override fun toJava(): com.pulumi.aws.sagemaker.inputs.SpaceSpaceSettingsCodeEditorAppSettingsArgs = com.pulumi.aws.sagemaker.inputs.SpaceSpaceSettingsCodeEditorAppSettingsArgs.builder()
        .defaultResourceSpec(
            defaultResourceSpec.applyValue({ args0 ->
                args0.let({ args0 ->
                    args0.toJava()
                })
            }),
        ).build()
}

/**
 * Builder for [SpaceSpaceSettingsCodeEditorAppSettingsArgs].
 */
@PulumiTagMarker
public class SpaceSpaceSettingsCodeEditorAppSettingsArgsBuilder internal constructor() {
    private var defaultResourceSpec:
        Output<SpaceSpaceSettingsCodeEditorAppSettingsDefaultResourceSpecArgs>? = null

    /**
     * @param value The default instance type and the Amazon Resource Name (ARN) of the SageMaker image created on the instance. See `default_resource_spec` Block below.
     */
    @JvmName("cnnakyfsdeghiqyh")
    public suspend fun defaultResourceSpec(`value`: Output<SpaceSpaceSettingsCodeEditorAppSettingsDefaultResourceSpecArgs>) {
        this.defaultResourceSpec = value
    }

    /**
     * @param value The default instance type and the Amazon Resource Name (ARN) of the SageMaker image created on the instance. See `default_resource_spec` Block below.
     */
    @JvmName("dvescxrqyyptbaau")
    public suspend fun defaultResourceSpec(`value`: SpaceSpaceSettingsCodeEditorAppSettingsDefaultResourceSpecArgs) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.defaultResourceSpec = mapped
    }

    /**
     * @param argument The default instance type and the Amazon Resource Name (ARN) of the SageMaker image created on the instance. See `default_resource_spec` Block below.
     */
    @JvmName("fsnwxwkjfhaqaaph")
    public suspend fun defaultResourceSpec(argument: suspend SpaceSpaceSettingsCodeEditorAppSettingsDefaultResourceSpecArgsBuilder.() -> Unit) {
        val toBeMapped =
            SpaceSpaceSettingsCodeEditorAppSettingsDefaultResourceSpecArgsBuilder().applySuspend {
                argument()
            }.build()
        val mapped = of(toBeMapped)
        this.defaultResourceSpec = mapped
    }

    internal fun build(): SpaceSpaceSettingsCodeEditorAppSettingsArgs =
        SpaceSpaceSettingsCodeEditorAppSettingsArgs(
            defaultResourceSpec = defaultResourceSpec ?: throw PulumiNullFieldException("defaultResourceSpec"),
        )
}
