@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.sagemaker.kotlin.inputs

import com.pulumi.aws.sagemaker.inputs.SpaceSpaceSettingsCustomFileSystemArgs.builder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiNullFieldException
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.applySuspend
import kotlin.Suppress
import kotlin.Unit
import kotlin.jvm.JvmName

/**
 *
 * @property efsFileSystem A custom file system in Amazon EFS. See `efs_file_system` Block below.
 */
public data class SpaceSpaceSettingsCustomFileSystemArgs(
    public val efsFileSystem: Output<SpaceSpaceSettingsCustomFileSystemEfsFileSystemArgs>,
) : ConvertibleToJava<com.pulumi.aws.sagemaker.inputs.SpaceSpaceSettingsCustomFileSystemArgs> {
    override fun toJava(): com.pulumi.aws.sagemaker.inputs.SpaceSpaceSettingsCustomFileSystemArgs =
        com.pulumi.aws.sagemaker.inputs.SpaceSpaceSettingsCustomFileSystemArgs.builder()
            .efsFileSystem(efsFileSystem.applyValue({ args0 -> args0.let({ args0 -> args0.toJava() }) })).build()
}

/**
 * Builder for [SpaceSpaceSettingsCustomFileSystemArgs].
 */
@PulumiTagMarker
public class SpaceSpaceSettingsCustomFileSystemArgsBuilder internal constructor() {
    private var efsFileSystem: Output<SpaceSpaceSettingsCustomFileSystemEfsFileSystemArgs>? = null

    /**
     * @param value A custom file system in Amazon EFS. See `efs_file_system` Block below.
     */
    @JvmName("mkobqqajypdifhsa")
    public suspend fun efsFileSystem(`value`: Output<SpaceSpaceSettingsCustomFileSystemEfsFileSystemArgs>) {
        this.efsFileSystem = value
    }

    /**
     * @param value A custom file system in Amazon EFS. See `efs_file_system` Block below.
     */
    @JvmName("ewrqopknkoditdtm")
    public suspend fun efsFileSystem(`value`: SpaceSpaceSettingsCustomFileSystemEfsFileSystemArgs) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.efsFileSystem = mapped
    }

    /**
     * @param argument A custom file system in Amazon EFS. See `efs_file_system` Block below.
     */
    @JvmName("ynwtxdbgrqbrlhne")
    public suspend fun efsFileSystem(argument: suspend SpaceSpaceSettingsCustomFileSystemEfsFileSystemArgsBuilder.() -> Unit) {
        val toBeMapped = SpaceSpaceSettingsCustomFileSystemEfsFileSystemArgsBuilder().applySuspend {
            argument()
        }.build()
        val mapped = of(toBeMapped)
        this.efsFileSystem = mapped
    }

    internal fun build(): SpaceSpaceSettingsCustomFileSystemArgs =
        SpaceSpaceSettingsCustomFileSystemArgs(
            efsFileSystem = efsFileSystem ?: throw PulumiNullFieldException("efsFileSystem"),
        )
}
