@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.sagemaker.kotlin.inputs

import com.pulumi.aws.sagemaker.inputs.SpaceSpaceSettingsCustomFileSystemEfsFileSystemArgs.builder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiNullFieldException
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.String
import kotlin.Suppress
import kotlin.jvm.JvmName

/**
 *
 * @property fileSystemId The ID of your Amazon EFS file system.
 */
public data class SpaceSpaceSettingsCustomFileSystemEfsFileSystemArgs(
    public val fileSystemId: Output<String>,
) :
    ConvertibleToJava<com.pulumi.aws.sagemaker.inputs.SpaceSpaceSettingsCustomFileSystemEfsFileSystemArgs> {
    override fun toJava(): com.pulumi.aws.sagemaker.inputs.SpaceSpaceSettingsCustomFileSystemEfsFileSystemArgs =
        com.pulumi.aws.sagemaker.inputs.SpaceSpaceSettingsCustomFileSystemEfsFileSystemArgs.builder()
            .fileSystemId(fileSystemId.applyValue({ args0 -> args0 })).build()
}

/**
 * Builder for [SpaceSpaceSettingsCustomFileSystemEfsFileSystemArgs].
 */
@PulumiTagMarker
public class SpaceSpaceSettingsCustomFileSystemEfsFileSystemArgsBuilder internal constructor() {
    private var fileSystemId: Output<String>? = null

    /**
     * @param value The ID of your Amazon EFS file system.
     */
    @JvmName("jycuttqmotmiydfg")
    public suspend fun fileSystemId(`value`: Output<String>) {
        this.fileSystemId = value
    }

    /**
     * @param value The ID of your Amazon EFS file system.
     */
    @JvmName("vdsosxgkssxcruyk")
    public suspend fun fileSystemId(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.fileSystemId = mapped
    }

    internal fun build(): SpaceSpaceSettingsCustomFileSystemEfsFileSystemArgs =
        SpaceSpaceSettingsCustomFileSystemEfsFileSystemArgs(
            fileSystemId = fileSystemId ?: throw PulumiNullFieldException("fileSystemId"),
        )
}
