@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.sagemaker.kotlin.inputs

import com.pulumi.aws.sagemaker.inputs.SpaceSpaceSettingsJupyterLabAppSettingsArgs.builder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiNullFieldException
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.applySuspend
import kotlin.Suppress
import kotlin.Unit
import kotlin.collections.List
import kotlin.jvm.JvmName

/**
 *
 * @property codeRepositories A list of Git repositories that SageMaker automatically displays to users for cloning in the JupyterServer application. See `code_repository` Block below.
 * @property defaultResourceSpec The default instance type and the Amazon Resource Name (ARN) of the SageMaker image created on the instance. See `default_resource_spec` Block below.
 */
public data class SpaceSpaceSettingsJupyterLabAppSettingsArgs(
    public val codeRepositories: Output<List<SpaceSpaceSettingsJupyterLabAppSettingsCodeRepositoryArgs>>? = null,
    public val defaultResourceSpec: Output<SpaceSpaceSettingsJupyterLabAppSettingsDefaultResourceSpecArgs>,
) : ConvertibleToJava<com.pulumi.aws.sagemaker.inputs.SpaceSpaceSettingsJupyterLabAppSettingsArgs> {
    override fun toJava(): com.pulumi.aws.sagemaker.inputs.SpaceSpaceSettingsJupyterLabAppSettingsArgs = com.pulumi.aws.sagemaker.inputs.SpaceSpaceSettingsJupyterLabAppSettingsArgs.builder()
        .codeRepositories(
            codeRepositories?.applyValue({ args0 ->
                args0.map({ args0 ->
                    args0.let({ args0 ->
                        args0.toJava()
                    })
                })
            }),
        )
        .defaultResourceSpec(
            defaultResourceSpec.applyValue({ args0 ->
                args0.let({ args0 ->
                    args0.toJava()
                })
            }),
        ).build()
}

/**
 * Builder for [SpaceSpaceSettingsJupyterLabAppSettingsArgs].
 */
@PulumiTagMarker
public class SpaceSpaceSettingsJupyterLabAppSettingsArgsBuilder internal constructor() {
    private var codeRepositories:
        Output<List<SpaceSpaceSettingsJupyterLabAppSettingsCodeRepositoryArgs>>? = null

    private var defaultResourceSpec:
        Output<SpaceSpaceSettingsJupyterLabAppSettingsDefaultResourceSpecArgs>? = null

    /**
     * @param value A list of Git repositories that SageMaker automatically displays to users for cloning in the JupyterServer application. See `code_repository` Block below.
     */
    @JvmName("xfiwoyttwcfqeaff")
    public suspend fun codeRepositories(`value`: Output<List<SpaceSpaceSettingsJupyterLabAppSettingsCodeRepositoryArgs>>) {
        this.codeRepositories = value
    }

    @JvmName("obqidhftfbklegng")
    public suspend fun codeRepositories(vararg values: Output<SpaceSpaceSettingsJupyterLabAppSettingsCodeRepositoryArgs>) {
        this.codeRepositories = Output.all(values.asList())
    }

    /**
     * @param values A list of Git repositories that SageMaker automatically displays to users for cloning in the JupyterServer application. See `code_repository` Block below.
     */
    @JvmName("vfqiiqxvndkewpxw")
    public suspend fun codeRepositories(values: List<Output<SpaceSpaceSettingsJupyterLabAppSettingsCodeRepositoryArgs>>) {
        this.codeRepositories = Output.all(values)
    }

    /**
     * @param value The default instance type and the Amazon Resource Name (ARN) of the SageMaker image created on the instance. See `default_resource_spec` Block below.
     */
    @JvmName("etqeqwximiddpedd")
    public suspend fun defaultResourceSpec(`value`: Output<SpaceSpaceSettingsJupyterLabAppSettingsDefaultResourceSpecArgs>) {
        this.defaultResourceSpec = value
    }

    /**
     * @param value A list of Git repositories that SageMaker automatically displays to users for cloning in the JupyterServer application. See `code_repository` Block below.
     */
    @JvmName("heospmqheslswiua")
    public suspend fun codeRepositories(`value`: List<SpaceSpaceSettingsJupyterLabAppSettingsCodeRepositoryArgs>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.codeRepositories = mapped
    }

    /**
     * @param argument A list of Git repositories that SageMaker automatically displays to users for cloning in the JupyterServer application. See `code_repository` Block below.
     */
    @JvmName("nriflnvlvetjijej")
    public suspend fun codeRepositories(argument: List<suspend SpaceSpaceSettingsJupyterLabAppSettingsCodeRepositoryArgsBuilder.() -> Unit>) {
        val toBeMapped = argument.toList().map {
            SpaceSpaceSettingsJupyterLabAppSettingsCodeRepositoryArgsBuilder().applySuspend {
                it()
            }.build()
        }
        val mapped = of(toBeMapped)
        this.codeRepositories = mapped
    }

    /**
     * @param argument A list of Git repositories that SageMaker automatically displays to users for cloning in the JupyterServer application. See `code_repository` Block below.
     */
    @JvmName("ylodkeugovereskt")
    public suspend fun codeRepositories(vararg argument: suspend SpaceSpaceSettingsJupyterLabAppSettingsCodeRepositoryArgsBuilder.() -> Unit) {
        val toBeMapped = argument.toList().map {
            SpaceSpaceSettingsJupyterLabAppSettingsCodeRepositoryArgsBuilder().applySuspend {
                it()
            }.build()
        }
        val mapped = of(toBeMapped)
        this.codeRepositories = mapped
    }

    /**
     * @param argument A list of Git repositories that SageMaker automatically displays to users for cloning in the JupyterServer application. See `code_repository` Block below.
     */
    @JvmName("ovqljwvjvcpsuoqk")
    public suspend fun codeRepositories(argument: suspend SpaceSpaceSettingsJupyterLabAppSettingsCodeRepositoryArgsBuilder.() -> Unit) {
        val toBeMapped =
            listOf(
                SpaceSpaceSettingsJupyterLabAppSettingsCodeRepositoryArgsBuilder().applySuspend {
                    argument()
                }.build(),
            )
        val mapped = of(toBeMapped)
        this.codeRepositories = mapped
    }

    /**
     * @param values A list of Git repositories that SageMaker automatically displays to users for cloning in the JupyterServer application. See `code_repository` Block below.
     */
    @JvmName("bhbivnpoqtsbsetc")
    public suspend fun codeRepositories(vararg values: SpaceSpaceSettingsJupyterLabAppSettingsCodeRepositoryArgs) {
        val toBeMapped = values.toList()
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.codeRepositories = mapped
    }

    /**
     * @param value The default instance type and the Amazon Resource Name (ARN) of the SageMaker image created on the instance. See `default_resource_spec` Block below.
     */
    @JvmName("avigbgejcipujait")
    public suspend fun defaultResourceSpec(`value`: SpaceSpaceSettingsJupyterLabAppSettingsDefaultResourceSpecArgs) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.defaultResourceSpec = mapped
    }

    /**
     * @param argument The default instance type and the Amazon Resource Name (ARN) of the SageMaker image created on the instance. See `default_resource_spec` Block below.
     */
    @JvmName("nydxgxfsyqkjwrjv")
    public suspend fun defaultResourceSpec(argument: suspend SpaceSpaceSettingsJupyterLabAppSettingsDefaultResourceSpecArgsBuilder.() -> Unit) {
        val toBeMapped =
            SpaceSpaceSettingsJupyterLabAppSettingsDefaultResourceSpecArgsBuilder().applySuspend {
                argument()
            }.build()
        val mapped = of(toBeMapped)
        this.defaultResourceSpec = mapped
    }

    internal fun build(): SpaceSpaceSettingsJupyterLabAppSettingsArgs =
        SpaceSpaceSettingsJupyterLabAppSettingsArgs(
            codeRepositories = codeRepositories,
            defaultResourceSpec = defaultResourceSpec ?: throw PulumiNullFieldException("defaultResourceSpec"),
        )
}
