@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.sagemaker.kotlin.inputs

import com.pulumi.aws.sagemaker.inputs.SpaceSpaceSettingsJupyterLabAppSettingsCodeRepositoryArgs.builder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiNullFieldException
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.String
import kotlin.Suppress
import kotlin.jvm.JvmName

/**
 *
 * @property repositoryUrl The URL of the Git repository.
 */
public data class SpaceSpaceSettingsJupyterLabAppSettingsCodeRepositoryArgs(
    public val repositoryUrl: Output<String>,
) :
    ConvertibleToJava<com.pulumi.aws.sagemaker.inputs.SpaceSpaceSettingsJupyterLabAppSettingsCodeRepositoryArgs> {
    override fun toJava(): com.pulumi.aws.sagemaker.inputs.SpaceSpaceSettingsJupyterLabAppSettingsCodeRepositoryArgs =
        com.pulumi.aws.sagemaker.inputs.SpaceSpaceSettingsJupyterLabAppSettingsCodeRepositoryArgs.builder()
            .repositoryUrl(repositoryUrl.applyValue({ args0 -> args0 })).build()
}

/**
 * Builder for [SpaceSpaceSettingsJupyterLabAppSettingsCodeRepositoryArgs].
 */
@PulumiTagMarker
public class SpaceSpaceSettingsJupyterLabAppSettingsCodeRepositoryArgsBuilder internal constructor() {
    private var repositoryUrl: Output<String>? = null

    /**
     * @param value The URL of the Git repository.
     */
    @JvmName("ulxturilxiklsdfk")
    public suspend fun repositoryUrl(`value`: Output<String>) {
        this.repositoryUrl = value
    }

    /**
     * @param value The URL of the Git repository.
     */
    @JvmName("xmywbhtqhrjipbag")
    public suspend fun repositoryUrl(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.repositoryUrl = mapped
    }

    internal fun build(): SpaceSpaceSettingsJupyterLabAppSettingsCodeRepositoryArgs =
        SpaceSpaceSettingsJupyterLabAppSettingsCodeRepositoryArgs(
            repositoryUrl = repositoryUrl ?: throw PulumiNullFieldException("repositoryUrl"),
        )
}
