@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.sagemaker.kotlin.inputs

import com.pulumi.aws.sagemaker.inputs.SpaceSpaceSettingsJupyterServerAppSettingsArgs.builder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiNullFieldException
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.applySuspend
import kotlin.String
import kotlin.Suppress
import kotlin.Unit
import kotlin.collections.List
import kotlin.jvm.JvmName

/**
 *
 * @property codeRepositories A list of Git repositories that SageMaker automatically displays to users for cloning in the JupyterServer application. See `code_repository` Block below.
 * @property defaultResourceSpec The default instance type and the Amazon Resource Name (ARN) of the SageMaker image created on the instance. See `default_resource_spec` Block below.
 * @property lifecycleConfigArns The Amazon Resource Name (ARN) of the Lifecycle Configurations.
 */
public data class SpaceSpaceSettingsJupyterServerAppSettingsArgs(
    public val codeRepositories: Output<List<SpaceSpaceSettingsJupyterServerAppSettingsCodeRepositoryArgs>>? = null,
    public val defaultResourceSpec: Output<SpaceSpaceSettingsJupyterServerAppSettingsDefaultResourceSpecArgs>,
    public val lifecycleConfigArns: Output<List<String>>? = null,
) :
    ConvertibleToJava<com.pulumi.aws.sagemaker.inputs.SpaceSpaceSettingsJupyterServerAppSettingsArgs> {
    override fun toJava(): com.pulumi.aws.sagemaker.inputs.SpaceSpaceSettingsJupyterServerAppSettingsArgs =
        com.pulumi.aws.sagemaker.inputs.SpaceSpaceSettingsJupyterServerAppSettingsArgs.builder()
            .codeRepositories(
                codeRepositories?.applyValue({ args0 ->
                    args0.map({ args0 ->
                        args0.let({ args0 ->
                            args0.toJava()
                        })
                    })
                }),
            )
            .defaultResourceSpec(
                defaultResourceSpec.applyValue({ args0 ->
                    args0.let({ args0 ->
                        args0.toJava()
                    })
                }),
            )
            .lifecycleConfigArns(
                lifecycleConfigArns?.applyValue({ args0 ->
                    args0.map({ args0 ->
                        args0
                    })
                }),
            ).build()
}

/**
 * Builder for [SpaceSpaceSettingsJupyterServerAppSettingsArgs].
 */
@PulumiTagMarker
public class SpaceSpaceSettingsJupyterServerAppSettingsArgsBuilder internal constructor() {
    private var codeRepositories:
        Output<List<SpaceSpaceSettingsJupyterServerAppSettingsCodeRepositoryArgs>>? = null

    private var defaultResourceSpec:
        Output<SpaceSpaceSettingsJupyterServerAppSettingsDefaultResourceSpecArgs>? = null

    private var lifecycleConfigArns: Output<List<String>>? = null

    /**
     * @param value A list of Git repositories that SageMaker automatically displays to users for cloning in the JupyterServer application. See `code_repository` Block below.
     */
    @JvmName("syynhyjmokbjuoac")
    public suspend fun codeRepositories(`value`: Output<List<SpaceSpaceSettingsJupyterServerAppSettingsCodeRepositoryArgs>>) {
        this.codeRepositories = value
    }

    @JvmName("cusjrowrttupvnmk")
    public suspend fun codeRepositories(vararg values: Output<SpaceSpaceSettingsJupyterServerAppSettingsCodeRepositoryArgs>) {
        this.codeRepositories = Output.all(values.asList())
    }

    /**
     * @param values A list of Git repositories that SageMaker automatically displays to users for cloning in the JupyterServer application. See `code_repository` Block below.
     */
    @JvmName("emqucrmlbfnhjrkn")
    public suspend fun codeRepositories(values: List<Output<SpaceSpaceSettingsJupyterServerAppSettingsCodeRepositoryArgs>>) {
        this.codeRepositories = Output.all(values)
    }

    /**
     * @param value The default instance type and the Amazon Resource Name (ARN) of the SageMaker image created on the instance. See `default_resource_spec` Block below.
     */
    @JvmName("oldbbyytffmfevtc")
    public suspend fun defaultResourceSpec(`value`: Output<SpaceSpaceSettingsJupyterServerAppSettingsDefaultResourceSpecArgs>) {
        this.defaultResourceSpec = value
    }

    /**
     * @param value The Amazon Resource Name (ARN) of the Lifecycle Configurations.
     */
    @JvmName("bdlkawwqyghasqih")
    public suspend fun lifecycleConfigArns(`value`: Output<List<String>>) {
        this.lifecycleConfigArns = value
    }

    @JvmName("llulaeudacussjug")
    public suspend fun lifecycleConfigArns(vararg values: Output<String>) {
        this.lifecycleConfigArns = Output.all(values.asList())
    }

    /**
     * @param values The Amazon Resource Name (ARN) of the Lifecycle Configurations.
     */
    @JvmName("rpphdwgvuekxqdaa")
    public suspend fun lifecycleConfigArns(values: List<Output<String>>) {
        this.lifecycleConfigArns = Output.all(values)
    }

    /**
     * @param value A list of Git repositories that SageMaker automatically displays to users for cloning in the JupyterServer application. See `code_repository` Block below.
     */
    @JvmName("ooixicomgnkatbbn")
    public suspend fun codeRepositories(`value`: List<SpaceSpaceSettingsJupyterServerAppSettingsCodeRepositoryArgs>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.codeRepositories = mapped
    }

    /**
     * @param argument A list of Git repositories that SageMaker automatically displays to users for cloning in the JupyterServer application. See `code_repository` Block below.
     */
    @JvmName("clkekjnxxjponwup")
    public suspend fun codeRepositories(argument: List<suspend SpaceSpaceSettingsJupyterServerAppSettingsCodeRepositoryArgsBuilder.() -> Unit>) {
        val toBeMapped = argument.toList().map {
            SpaceSpaceSettingsJupyterServerAppSettingsCodeRepositoryArgsBuilder().applySuspend {
                it()
            }.build()
        }
        val mapped = of(toBeMapped)
        this.codeRepositories = mapped
    }

    /**
     * @param argument A list of Git repositories that SageMaker automatically displays to users for cloning in the JupyterServer application. See `code_repository` Block below.
     */
    @JvmName("uwenychgxpsgmkys")
    public suspend fun codeRepositories(vararg argument: suspend SpaceSpaceSettingsJupyterServerAppSettingsCodeRepositoryArgsBuilder.() -> Unit) {
        val toBeMapped = argument.toList().map {
            SpaceSpaceSettingsJupyterServerAppSettingsCodeRepositoryArgsBuilder().applySuspend {
                it()
            }.build()
        }
        val mapped = of(toBeMapped)
        this.codeRepositories = mapped
    }

    /**
     * @param argument A list of Git repositories that SageMaker automatically displays to users for cloning in the JupyterServer application. See `code_repository` Block below.
     */
    @JvmName("gjmbiuajhnadnrwp")
    public suspend fun codeRepositories(argument: suspend SpaceSpaceSettingsJupyterServerAppSettingsCodeRepositoryArgsBuilder.() -> Unit) {
        val toBeMapped =
            listOf(
                SpaceSpaceSettingsJupyterServerAppSettingsCodeRepositoryArgsBuilder().applySuspend {
                    argument()
                }.build(),
            )
        val mapped = of(toBeMapped)
        this.codeRepositories = mapped
    }

    /**
     * @param values A list of Git repositories that SageMaker automatically displays to users for cloning in the JupyterServer application. See `code_repository` Block below.
     */
    @JvmName("ygduladrcnmjaeqt")
    public suspend fun codeRepositories(vararg values: SpaceSpaceSettingsJupyterServerAppSettingsCodeRepositoryArgs) {
        val toBeMapped = values.toList()
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.codeRepositories = mapped
    }

    /**
     * @param value The default instance type and the Amazon Resource Name (ARN) of the SageMaker image created on the instance. See `default_resource_spec` Block below.
     */
    @JvmName("vhnwmymelebugsmq")
    public suspend fun defaultResourceSpec(`value`: SpaceSpaceSettingsJupyterServerAppSettingsDefaultResourceSpecArgs) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.defaultResourceSpec = mapped
    }

    /**
     * @param argument The default instance type and the Amazon Resource Name (ARN) of the SageMaker image created on the instance. See `default_resource_spec` Block below.
     */
    @JvmName("polxhbtskeuoocpe")
    public suspend fun defaultResourceSpec(argument: suspend SpaceSpaceSettingsJupyterServerAppSettingsDefaultResourceSpecArgsBuilder.() -> Unit) {
        val toBeMapped =
            SpaceSpaceSettingsJupyterServerAppSettingsDefaultResourceSpecArgsBuilder().applySuspend {
                argument()
            }.build()
        val mapped = of(toBeMapped)
        this.defaultResourceSpec = mapped
    }

    /**
     * @param value The Amazon Resource Name (ARN) of the Lifecycle Configurations.
     */
    @JvmName("sghccbqthkiwsqvh")
    public suspend fun lifecycleConfigArns(`value`: List<String>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.lifecycleConfigArns = mapped
    }

    /**
     * @param values The Amazon Resource Name (ARN) of the Lifecycle Configurations.
     */
    @JvmName("ntxtpepikrjtduiw")
    public suspend fun lifecycleConfigArns(vararg values: String) {
        val toBeMapped = values.toList()
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.lifecycleConfigArns = mapped
    }

    internal fun build(): SpaceSpaceSettingsJupyterServerAppSettingsArgs =
        SpaceSpaceSettingsJupyterServerAppSettingsArgs(
            codeRepositories = codeRepositories,
            defaultResourceSpec = defaultResourceSpec ?: throw PulumiNullFieldException("defaultResourceSpec"),
            lifecycleConfigArns = lifecycleConfigArns,
        )
}
