@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.sagemaker.kotlin.inputs

import com.pulumi.aws.sagemaker.inputs.SpaceSpaceSettingsJupyterServerAppSettingsCodeRepositoryArgs.builder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiNullFieldException
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.String
import kotlin.Suppress
import kotlin.jvm.JvmName

/**
 *
 * @property repositoryUrl The URL of the Git repository.
 */
public data class SpaceSpaceSettingsJupyterServerAppSettingsCodeRepositoryArgs(
    public val repositoryUrl: Output<String>,
) :
    ConvertibleToJava<com.pulumi.aws.sagemaker.inputs.SpaceSpaceSettingsJupyterServerAppSettingsCodeRepositoryArgs> {
    override fun toJava(): com.pulumi.aws.sagemaker.inputs.SpaceSpaceSettingsJupyterServerAppSettingsCodeRepositoryArgs =
        com.pulumi.aws.sagemaker.inputs.SpaceSpaceSettingsJupyterServerAppSettingsCodeRepositoryArgs.builder()
            .repositoryUrl(repositoryUrl.applyValue({ args0 -> args0 })).build()
}

/**
 * Builder for [SpaceSpaceSettingsJupyterServerAppSettingsCodeRepositoryArgs].
 */
@PulumiTagMarker
public class SpaceSpaceSettingsJupyterServerAppSettingsCodeRepositoryArgsBuilder internal constructor() {
    private var repositoryUrl: Output<String>? = null

    /**
     * @param value The URL of the Git repository.
     */
    @JvmName("imtdyijrohbmttim")
    public suspend fun repositoryUrl(`value`: Output<String>) {
        this.repositoryUrl = value
    }

    /**
     * @param value The URL of the Git repository.
     */
    @JvmName("winyduigppxoxfeb")
    public suspend fun repositoryUrl(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.repositoryUrl = mapped
    }

    internal fun build(): SpaceSpaceSettingsJupyterServerAppSettingsCodeRepositoryArgs =
        SpaceSpaceSettingsJupyterServerAppSettingsCodeRepositoryArgs(
            repositoryUrl = repositoryUrl ?: throw PulumiNullFieldException("repositoryUrl"),
        )
}
