@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.sagemaker.kotlin.inputs

import com.pulumi.aws.sagemaker.inputs.SpaceSpaceSettingsKernelGatewayAppSettingsDefaultResourceSpecArgs.builder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.String
import kotlin.Suppress
import kotlin.jvm.JvmName

/**
 *
 * @property instanceType The instance type.
 * @property lifecycleConfigArn The Amazon Resource Name (ARN) of the Lifecycle Configuration attached to the Resource.
 * @property sagemakerImageArn The Amazon Resource Name (ARN) of the SageMaker image created on the instance.
 * @property sagemakerImageVersionAlias The SageMaker Image Version Alias.
 * @property sagemakerImageVersionArn The ARN of the image version created on the instance.
 */
public data class SpaceSpaceSettingsKernelGatewayAppSettingsDefaultResourceSpecArgs(
    public val instanceType: Output<String>? = null,
    public val lifecycleConfigArn: Output<String>? = null,
    public val sagemakerImageArn: Output<String>? = null,
    public val sagemakerImageVersionAlias: Output<String>? = null,
    public val sagemakerImageVersionArn: Output<String>? = null,
) :
    ConvertibleToJava<com.pulumi.aws.sagemaker.inputs.SpaceSpaceSettingsKernelGatewayAppSettingsDefaultResourceSpecArgs> {
    override fun toJava(): com.pulumi.aws.sagemaker.inputs.SpaceSpaceSettingsKernelGatewayAppSettingsDefaultResourceSpecArgs =
        com.pulumi.aws.sagemaker.inputs.SpaceSpaceSettingsKernelGatewayAppSettingsDefaultResourceSpecArgs.builder()
            .instanceType(instanceType?.applyValue({ args0 -> args0 }))
            .lifecycleConfigArn(lifecycleConfigArn?.applyValue({ args0 -> args0 }))
            .sagemakerImageArn(sagemakerImageArn?.applyValue({ args0 -> args0 }))
            .sagemakerImageVersionAlias(sagemakerImageVersionAlias?.applyValue({ args0 -> args0 }))
            .sagemakerImageVersionArn(sagemakerImageVersionArn?.applyValue({ args0 -> args0 })).build()
}

/**
 * Builder for [SpaceSpaceSettingsKernelGatewayAppSettingsDefaultResourceSpecArgs].
 */
@PulumiTagMarker
public class SpaceSpaceSettingsKernelGatewayAppSettingsDefaultResourceSpecArgsBuilder internal constructor() {
    private var instanceType: Output<String>? = null

    private var lifecycleConfigArn: Output<String>? = null

    private var sagemakerImageArn: Output<String>? = null

    private var sagemakerImageVersionAlias: Output<String>? = null

    private var sagemakerImageVersionArn: Output<String>? = null

    /**
     * @param value The instance type.
     */
    @JvmName("mwfajsfpskutbddc")
    public suspend fun instanceType(`value`: Output<String>) {
        this.instanceType = value
    }

    /**
     * @param value The Amazon Resource Name (ARN) of the Lifecycle Configuration attached to the Resource.
     */
    @JvmName("rsdefnffsqavtffs")
    public suspend fun lifecycleConfigArn(`value`: Output<String>) {
        this.lifecycleConfigArn = value
    }

    /**
     * @param value The Amazon Resource Name (ARN) of the SageMaker image created on the instance.
     */
    @JvmName("bnqlpswulijdmkvo")
    public suspend fun sagemakerImageArn(`value`: Output<String>) {
        this.sagemakerImageArn = value
    }

    /**
     * @param value The SageMaker Image Version Alias.
     */
    @JvmName("iebyjbmtbndxonhs")
    public suspend fun sagemakerImageVersionAlias(`value`: Output<String>) {
        this.sagemakerImageVersionAlias = value
    }

    /**
     * @param value The ARN of the image version created on the instance.
     */
    @JvmName("udelsvwvdacjwomh")
    public suspend fun sagemakerImageVersionArn(`value`: Output<String>) {
        this.sagemakerImageVersionArn = value
    }

    /**
     * @param value The instance type.
     */
    @JvmName("graaqcsurmjydoib")
    public suspend fun instanceType(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.instanceType = mapped
    }

    /**
     * @param value The Amazon Resource Name (ARN) of the Lifecycle Configuration attached to the Resource.
     */
    @JvmName("pgacecvcvcejnpgk")
    public suspend fun lifecycleConfigArn(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.lifecycleConfigArn = mapped
    }

    /**
     * @param value The Amazon Resource Name (ARN) of the SageMaker image created on the instance.
     */
    @JvmName("lcvbqoswatigqmnk")
    public suspend fun sagemakerImageArn(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.sagemakerImageArn = mapped
    }

    /**
     * @param value The SageMaker Image Version Alias.
     */
    @JvmName("jlyclglnxfayfbkm")
    public suspend fun sagemakerImageVersionAlias(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.sagemakerImageVersionAlias = mapped
    }

    /**
     * @param value The ARN of the image version created on the instance.
     */
    @JvmName("oykpjhkduecgwdld")
    public suspend fun sagemakerImageVersionArn(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.sagemakerImageVersionArn = mapped
    }

    internal fun build(): SpaceSpaceSettingsKernelGatewayAppSettingsDefaultResourceSpecArgs =
        SpaceSpaceSettingsKernelGatewayAppSettingsDefaultResourceSpecArgs(
            instanceType = instanceType,
            lifecycleConfigArn = lifecycleConfigArn,
            sagemakerImageArn = sagemakerImageArn,
            sagemakerImageVersionAlias = sagemakerImageVersionAlias,
            sagemakerImageVersionArn = sagemakerImageVersionArn,
        )
}
