@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.sagemaker.kotlin.inputs

import com.pulumi.aws.sagemaker.inputs.SpaceSpaceSettingsSpaceStorageSettingsArgs.builder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiNullFieldException
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.applySuspend
import kotlin.Suppress
import kotlin.Unit
import kotlin.jvm.JvmName

/**
 *
 * @property ebsStorageSettings A collection of EBS storage settings for a space. See `ebs_storage_settings` Block below.
 */
public data class SpaceSpaceSettingsSpaceStorageSettingsArgs(
    public val ebsStorageSettings: Output<SpaceSpaceSettingsSpaceStorageSettingsEbsStorageSettingsArgs>,
) : ConvertibleToJava<com.pulumi.aws.sagemaker.inputs.SpaceSpaceSettingsSpaceStorageSettingsArgs> {
    override fun toJava(): com.pulumi.aws.sagemaker.inputs.SpaceSpaceSettingsSpaceStorageSettingsArgs = com.pulumi.aws.sagemaker.inputs.SpaceSpaceSettingsSpaceStorageSettingsArgs.builder()
        .ebsStorageSettings(
            ebsStorageSettings.applyValue({ args0 ->
                args0.let({ args0 ->
                    args0.toJava()
                })
            }),
        ).build()
}

/**
 * Builder for [SpaceSpaceSettingsSpaceStorageSettingsArgs].
 */
@PulumiTagMarker
public class SpaceSpaceSettingsSpaceStorageSettingsArgsBuilder internal constructor() {
    private var ebsStorageSettings:
        Output<SpaceSpaceSettingsSpaceStorageSettingsEbsStorageSettingsArgs>? = null

    /**
     * @param value A collection of EBS storage settings for a space. See `ebs_storage_settings` Block below.
     */
    @JvmName("pcnfklbqjoychgls")
    public suspend fun ebsStorageSettings(`value`: Output<SpaceSpaceSettingsSpaceStorageSettingsEbsStorageSettingsArgs>) {
        this.ebsStorageSettings = value
    }

    /**
     * @param value A collection of EBS storage settings for a space. See `ebs_storage_settings` Block below.
     */
    @JvmName("yqhtksfwlwrhlilq")
    public suspend fun ebsStorageSettings(`value`: SpaceSpaceSettingsSpaceStorageSettingsEbsStorageSettingsArgs) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.ebsStorageSettings = mapped
    }

    /**
     * @param argument A collection of EBS storage settings for a space. See `ebs_storage_settings` Block below.
     */
    @JvmName("hqfslgvmoiwnugdg")
    public suspend fun ebsStorageSettings(argument: suspend SpaceSpaceSettingsSpaceStorageSettingsEbsStorageSettingsArgsBuilder.() -> Unit) {
        val toBeMapped =
            SpaceSpaceSettingsSpaceStorageSettingsEbsStorageSettingsArgsBuilder().applySuspend {
                argument()
            }.build()
        val mapped = of(toBeMapped)
        this.ebsStorageSettings = mapped
    }

    internal fun build(): SpaceSpaceSettingsSpaceStorageSettingsArgs =
        SpaceSpaceSettingsSpaceStorageSettingsArgs(
            ebsStorageSettings = ebsStorageSettings ?: throw PulumiNullFieldException("ebsStorageSettings"),
        )
}
