@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.sagemaker.kotlin.inputs

import com.pulumi.aws.sagemaker.inputs.SpaceSpaceSettingsSpaceStorageSettingsEbsStorageSettingsArgs.builder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiNullFieldException
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.Int
import kotlin.Suppress
import kotlin.jvm.JvmName

/**
 *
 * @property ebsVolumeSizeInGb The size of an EBS storage volume for a space.
 */
public data class SpaceSpaceSettingsSpaceStorageSettingsEbsStorageSettingsArgs(
    public val ebsVolumeSizeInGb: Output<Int>,
) :
    ConvertibleToJava<com.pulumi.aws.sagemaker.inputs.SpaceSpaceSettingsSpaceStorageSettingsEbsStorageSettingsArgs> {
    override fun toJava(): com.pulumi.aws.sagemaker.inputs.SpaceSpaceSettingsSpaceStorageSettingsEbsStorageSettingsArgs =
        com.pulumi.aws.sagemaker.inputs.SpaceSpaceSettingsSpaceStorageSettingsEbsStorageSettingsArgs.builder()
            .ebsVolumeSizeInGb(ebsVolumeSizeInGb.applyValue({ args0 -> args0 })).build()
}

/**
 * Builder for [SpaceSpaceSettingsSpaceStorageSettingsEbsStorageSettingsArgs].
 */
@PulumiTagMarker
public class SpaceSpaceSettingsSpaceStorageSettingsEbsStorageSettingsArgsBuilder internal constructor() {
    private var ebsVolumeSizeInGb: Output<Int>? = null

    /**
     * @param value The size of an EBS storage volume for a space.
     */
    @JvmName("cfglhnsaltlbvgwt")
    public suspend fun ebsVolumeSizeInGb(`value`: Output<Int>) {
        this.ebsVolumeSizeInGb = value
    }

    /**
     * @param value The size of an EBS storage volume for a space.
     */
    @JvmName("pmxanoonetoyiesw")
    public suspend fun ebsVolumeSizeInGb(`value`: Int) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.ebsVolumeSizeInGb = mapped
    }

    internal fun build(): SpaceSpaceSettingsSpaceStorageSettingsEbsStorageSettingsArgs =
        SpaceSpaceSettingsSpaceStorageSettingsEbsStorageSettingsArgs(
            ebsVolumeSizeInGb = ebsVolumeSizeInGb ?: throw PulumiNullFieldException("ebsVolumeSizeInGb"),
        )
}
