@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.sagemaker.kotlin.inputs

import com.pulumi.aws.sagemaker.inputs.SpaceSpaceSharingSettingsArgs.builder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiNullFieldException
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.String
import kotlin.Suppress
import kotlin.jvm.JvmName

/**
 *
 * @property sharingType Specifies the sharing type of the space. Valid values are `Private` and `Shared`.
 */
public data class SpaceSpaceSharingSettingsArgs(
    public val sharingType: Output<String>,
) : ConvertibleToJava<com.pulumi.aws.sagemaker.inputs.SpaceSpaceSharingSettingsArgs> {
    override fun toJava(): com.pulumi.aws.sagemaker.inputs.SpaceSpaceSharingSettingsArgs =
        com.pulumi.aws.sagemaker.inputs.SpaceSpaceSharingSettingsArgs.builder()
            .sharingType(sharingType.applyValue({ args0 -> args0 })).build()
}

/**
 * Builder for [SpaceSpaceSharingSettingsArgs].
 */
@PulumiTagMarker
public class SpaceSpaceSharingSettingsArgsBuilder internal constructor() {
    private var sharingType: Output<String>? = null

    /**
     * @param value Specifies the sharing type of the space. Valid values are `Private` and `Shared`.
     */
    @JvmName("vkcixkcswiurxjch")
    public suspend fun sharingType(`value`: Output<String>) {
        this.sharingType = value
    }

    /**
     * @param value Specifies the sharing type of the space. Valid values are `Private` and `Shared`.
     */
    @JvmName("vcvvbfchknymyory")
    public suspend fun sharingType(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.sharingType = mapped
    }

    internal fun build(): SpaceSpaceSharingSettingsArgs = SpaceSpaceSharingSettingsArgs(
        sharingType = sharingType ?: throw PulumiNullFieldException("sharingType"),
    )
}
