@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.sagemaker.kotlin.inputs

import com.pulumi.aws.sagemaker.inputs.UserProfileUserSettingsArgs.builder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiNullFieldException
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.applySuspend
import kotlin.String
import kotlin.Suppress
import kotlin.Unit
import kotlin.collections.List
import kotlin.jvm.JvmName

/**
 *
 * @property canvasAppSettings The Canvas app settings. See Canvas App Settings below.
 * @property codeEditorAppSettings The Code Editor application settings. See Code Editor App Settings below.
 * @property customFileSystemConfigs The settings for assigning a custom file system to a user profile. Permitted users can access this file system in Amazon SageMaker Studio. See Custom File System Config below.
 * @property customPosixUserConfig Details about the POSIX identity that is used for file system operations. See Custom Posix User Config below.
 * @property defaultLandingUri The default experience that the user is directed to when accessing the domain. The supported values are: `studio::`: Indicates that Studio is the default experience. This value can only be passed if StudioWebPortal is set to ENABLED. `app:JupyterServer:`: Indicates that Studio Classic is the default experience.
 * @property executionRole The execution role ARN for the user.
 * @property jupyterLabAppSettings The settings for the JupyterLab application. See Jupyter Lab App Settings below.
 * @property jupyterServerAppSettings The Jupyter server's app settings. See Jupyter Server App Settings below.
 * @property kernelGatewayAppSettings The kernel gateway app settings. See Kernel Gateway App Settings below.
 * @property rSessionAppSettings The RSession app settings. See RSession App Settings below.
 * @property rStudioServerProAppSettings A collection of settings that configure user interaction with the RStudioServerPro app. See RStudioServerProAppSettings below.
 * @property securityGroups A list of security group IDs that will be attached to the user.
 * @property sharingSettings The sharing settings. See Sharing Settings below.
 * @property spaceStorageSettings The storage settings for a private space. See Space Storage Settings below.
 * @property studioWebPortal Whether the user can access Studio. If this value is set to `DISABLED`, the user cannot access Studio, even if that is the default experience for the domain. Valid values are `ENABLED` and `DISABLED`.
 * @property tensorBoardAppSettings The TensorBoard app settings. See TensorBoard App Settings below.
 */
public data class UserProfileUserSettingsArgs(
    public val canvasAppSettings: Output<UserProfileUserSettingsCanvasAppSettingsArgs>? = null,
    public val codeEditorAppSettings: Output<UserProfileUserSettingsCodeEditorAppSettingsArgs>? =
        null,
    public val customFileSystemConfigs: Output<List<UserProfileUserSettingsCustomFileSystemConfigArgs>>? = null,
    public val customPosixUserConfig: Output<UserProfileUserSettingsCustomPosixUserConfigArgs>? =
        null,
    public val defaultLandingUri: Output<String>? = null,
    public val executionRole: Output<String>,
    public val jupyterLabAppSettings: Output<UserProfileUserSettingsJupyterLabAppSettingsArgs>? =
        null,
    public val jupyterServerAppSettings: Output<UserProfileUserSettingsJupyterServerAppSettingsArgs>? =
        null,
    public val kernelGatewayAppSettings: Output<UserProfileUserSettingsKernelGatewayAppSettingsArgs>? =
        null,
    public val rSessionAppSettings: Output<UserProfileUserSettingsRSessionAppSettingsArgs>? = null,
    public val rStudioServerProAppSettings: Output<UserProfileUserSettingsRStudioServerProAppSettingsArgs>? = null,
    public val securityGroups: Output<List<String>>? = null,
    public val sharingSettings: Output<UserProfileUserSettingsSharingSettingsArgs>? = null,
    public val spaceStorageSettings: Output<UserProfileUserSettingsSpaceStorageSettingsArgs>? = null,
    public val studioWebPortal: Output<String>? = null,
    public val tensorBoardAppSettings: Output<UserProfileUserSettingsTensorBoardAppSettingsArgs>? =
        null,
) : ConvertibleToJava<com.pulumi.aws.sagemaker.inputs.UserProfileUserSettingsArgs> {
    override fun toJava(): com.pulumi.aws.sagemaker.inputs.UserProfileUserSettingsArgs =
        com.pulumi.aws.sagemaker.inputs.UserProfileUserSettingsArgs.builder()
            .canvasAppSettings(canvasAppSettings?.applyValue({ args0 -> args0.let({ args0 -> args0.toJava() }) }))
            .codeEditorAppSettings(
                codeEditorAppSettings?.applyValue({ args0 ->
                    args0.let({ args0 ->
                        args0.toJava()
                    })
                }),
            )
            .customFileSystemConfigs(
                customFileSystemConfigs?.applyValue({ args0 ->
                    args0.map({ args0 ->
                        args0.let({ args0 -> args0.toJava() })
                    })
                }),
            )
            .customPosixUserConfig(
                customPosixUserConfig?.applyValue({ args0 ->
                    args0.let({ args0 ->
                        args0.toJava()
                    })
                }),
            )
            .defaultLandingUri(defaultLandingUri?.applyValue({ args0 -> args0 }))
            .executionRole(executionRole.applyValue({ args0 -> args0 }))
            .jupyterLabAppSettings(
                jupyterLabAppSettings?.applyValue({ args0 ->
                    args0.let({ args0 ->
                        args0.toJava()
                    })
                }),
            )
            .jupyterServerAppSettings(
                jupyterServerAppSettings?.applyValue({ args0 ->
                    args0.let({ args0 ->
                        args0.toJava()
                    })
                }),
            )
            .kernelGatewayAppSettings(
                kernelGatewayAppSettings?.applyValue({ args0 ->
                    args0.let({ args0 ->
                        args0.toJava()
                    })
                }),
            )
            .rSessionAppSettings(
                rSessionAppSettings?.applyValue({ args0 ->
                    args0.let({ args0 ->
                        args0.toJava()
                    })
                }),
            )
            .rStudioServerProAppSettings(
                rStudioServerProAppSettings?.applyValue({ args0 ->
                    args0.let({ args0 ->
                        args0.toJava()
                    })
                }),
            )
            .securityGroups(securityGroups?.applyValue({ args0 -> args0.map({ args0 -> args0 }) }))
            .sharingSettings(sharingSettings?.applyValue({ args0 -> args0.let({ args0 -> args0.toJava() }) }))
            .spaceStorageSettings(
                spaceStorageSettings?.applyValue({ args0 ->
                    args0.let({ args0 ->
                        args0.toJava()
                    })
                }),
            )
            .studioWebPortal(studioWebPortal?.applyValue({ args0 -> args0 }))
            .tensorBoardAppSettings(
                tensorBoardAppSettings?.applyValue({ args0 ->
                    args0.let({ args0 ->
                        args0.toJava()
                    })
                }),
            ).build()
}

/**
 * Builder for [UserProfileUserSettingsArgs].
 */
@PulumiTagMarker
public class UserProfileUserSettingsArgsBuilder internal constructor() {
    private var canvasAppSettings: Output<UserProfileUserSettingsCanvasAppSettingsArgs>? = null

    private var codeEditorAppSettings: Output<UserProfileUserSettingsCodeEditorAppSettingsArgs>? =
        null

    private var customFileSystemConfigs:
        Output<List<UserProfileUserSettingsCustomFileSystemConfigArgs>>? = null

    private var customPosixUserConfig: Output<UserProfileUserSettingsCustomPosixUserConfigArgs>? =
        null

    private var defaultLandingUri: Output<String>? = null

    private var executionRole: Output<String>? = null

    private var jupyterLabAppSettings: Output<UserProfileUserSettingsJupyterLabAppSettingsArgs>? =
        null

    private var jupyterServerAppSettings: Output<UserProfileUserSettingsJupyterServerAppSettingsArgs>? =
        null

    private var kernelGatewayAppSettings: Output<UserProfileUserSettingsKernelGatewayAppSettingsArgs>? =
        null

    private var rSessionAppSettings: Output<UserProfileUserSettingsRSessionAppSettingsArgs>? = null

    private var rStudioServerProAppSettings:
        Output<UserProfileUserSettingsRStudioServerProAppSettingsArgs>? = null

    private var securityGroups: Output<List<String>>? = null

    private var sharingSettings: Output<UserProfileUserSettingsSharingSettingsArgs>? = null

    private var spaceStorageSettings: Output<UserProfileUserSettingsSpaceStorageSettingsArgs>? = null

    private var studioWebPortal: Output<String>? = null

    private var tensorBoardAppSettings: Output<UserProfileUserSettingsTensorBoardAppSettingsArgs>? =
        null

    /**
     * @param value The Canvas app settings. See Canvas App Settings below.
     */
    @JvmName("wkalnqigjnslnfqg")
    public suspend fun canvasAppSettings(`value`: Output<UserProfileUserSettingsCanvasAppSettingsArgs>) {
        this.canvasAppSettings = value
    }

    /**
     * @param value The Code Editor application settings. See Code Editor App Settings below.
     */
    @JvmName("qdesimprpnnagkah")
    public suspend fun codeEditorAppSettings(`value`: Output<UserProfileUserSettingsCodeEditorAppSettingsArgs>) {
        this.codeEditorAppSettings = value
    }

    /**
     * @param value The settings for assigning a custom file system to a user profile. Permitted users can access this file system in Amazon SageMaker Studio. See Custom File System Config below.
     */
    @JvmName("xpyjrggjivvoejcb")
    public suspend fun customFileSystemConfigs(`value`: Output<List<UserProfileUserSettingsCustomFileSystemConfigArgs>>) {
        this.customFileSystemConfigs = value
    }

    @JvmName("qhsrtndkhiegntwd")
    public suspend fun customFileSystemConfigs(vararg values: Output<UserProfileUserSettingsCustomFileSystemConfigArgs>) {
        this.customFileSystemConfigs = Output.all(values.asList())
    }

    /**
     * @param values The settings for assigning a custom file system to a user profile. Permitted users can access this file system in Amazon SageMaker Studio. See Custom File System Config below.
     */
    @JvmName("vlacajyabhvdcttk")
    public suspend fun customFileSystemConfigs(values: List<Output<UserProfileUserSettingsCustomFileSystemConfigArgs>>) {
        this.customFileSystemConfigs = Output.all(values)
    }

    /**
     * @param value Details about the POSIX identity that is used for file system operations. See Custom Posix User Config below.
     */
    @JvmName("xyjdglwupnewvctf")
    public suspend fun customPosixUserConfig(`value`: Output<UserProfileUserSettingsCustomPosixUserConfigArgs>) {
        this.customPosixUserConfig = value
    }

    /**
     * @param value The default experience that the user is directed to when accessing the domain. The supported values are: `studio::`: Indicates that Studio is the default experience. This value can only be passed if StudioWebPortal is set to ENABLED. `app:JupyterServer:`: Indicates that Studio Classic is the default experience.
     */
    @JvmName("jrofvsswehrpcwgk")
    public suspend fun defaultLandingUri(`value`: Output<String>) {
        this.defaultLandingUri = value
    }

    /**
     * @param value The execution role ARN for the user.
     */
    @JvmName("gdkqnnjuyeobvwwi")
    public suspend fun executionRole(`value`: Output<String>) {
        this.executionRole = value
    }

    /**
     * @param value The settings for the JupyterLab application. See Jupyter Lab App Settings below.
     */
    @JvmName("fdwthfybhnbnneyv")
    public suspend fun jupyterLabAppSettings(`value`: Output<UserProfileUserSettingsJupyterLabAppSettingsArgs>) {
        this.jupyterLabAppSettings = value
    }

    /**
     * @param value The Jupyter server's app settings. See Jupyter Server App Settings below.
     */
    @JvmName("lscolrukfqhlvipl")
    public suspend fun jupyterServerAppSettings(`value`: Output<UserProfileUserSettingsJupyterServerAppSettingsArgs>) {
        this.jupyterServerAppSettings = value
    }

    /**
     * @param value The kernel gateway app settings. See Kernel Gateway App Settings below.
     */
    @JvmName("qhclsgrfqvgwtseh")
    public suspend fun kernelGatewayAppSettings(`value`: Output<UserProfileUserSettingsKernelGatewayAppSettingsArgs>) {
        this.kernelGatewayAppSettings = value
    }

    /**
     * @param value The RSession app settings. See RSession App Settings below.
     */
    @JvmName("xrjvhjsshimgkxkb")
    public suspend fun rSessionAppSettings(`value`: Output<UserProfileUserSettingsRSessionAppSettingsArgs>) {
        this.rSessionAppSettings = value
    }

    /**
     * @param value A collection of settings that configure user interaction with the RStudioServerPro app. See RStudioServerProAppSettings below.
     */
    @JvmName("baljxwjhfywnrmwq")
    public suspend fun rStudioServerProAppSettings(`value`: Output<UserProfileUserSettingsRStudioServerProAppSettingsArgs>) {
        this.rStudioServerProAppSettings = value
    }

    /**
     * @param value A list of security group IDs that will be attached to the user.
     */
    @JvmName("cokaxmvqlulpnlbt")
    public suspend fun securityGroups(`value`: Output<List<String>>) {
        this.securityGroups = value
    }

    @JvmName("cbmbekimhnbkbrrx")
    public suspend fun securityGroups(vararg values: Output<String>) {
        this.securityGroups = Output.all(values.asList())
    }

    /**
     * @param values A list of security group IDs that will be attached to the user.
     */
    @JvmName("reupwlmgvnccyxpg")
    public suspend fun securityGroups(values: List<Output<String>>) {
        this.securityGroups = Output.all(values)
    }

    /**
     * @param value The sharing settings. See Sharing Settings below.
     */
    @JvmName("lrvhobfgmwuuioyc")
    public suspend fun sharingSettings(`value`: Output<UserProfileUserSettingsSharingSettingsArgs>) {
        this.sharingSettings = value
    }

    /**
     * @param value The storage settings for a private space. See Space Storage Settings below.
     */
    @JvmName("rkptmsiorcyfsqyt")
    public suspend fun spaceStorageSettings(`value`: Output<UserProfileUserSettingsSpaceStorageSettingsArgs>) {
        this.spaceStorageSettings = value
    }

    /**
     * @param value Whether the user can access Studio. If this value is set to `DISABLED`, the user cannot access Studio, even if that is the default experience for the domain. Valid values are `ENABLED` and `DISABLED`.
     */
    @JvmName("ktyaqwsqtyddpqld")
    public suspend fun studioWebPortal(`value`: Output<String>) {
        this.studioWebPortal = value
    }

    /**
     * @param value The TensorBoard app settings. See TensorBoard App Settings below.
     */
    @JvmName("bxpxpvenkcefsnaf")
    public suspend fun tensorBoardAppSettings(`value`: Output<UserProfileUserSettingsTensorBoardAppSettingsArgs>) {
        this.tensorBoardAppSettings = value
    }

    /**
     * @param value The Canvas app settings. See Canvas App Settings below.
     */
    @JvmName("jdtbiagctiurxuoc")
    public suspend fun canvasAppSettings(`value`: UserProfileUserSettingsCanvasAppSettingsArgs?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.canvasAppSettings = mapped
    }

    /**
     * @param argument The Canvas app settings. See Canvas App Settings below.
     */
    @JvmName("phgawfgyvmogftcc")
    public suspend fun canvasAppSettings(argument: suspend UserProfileUserSettingsCanvasAppSettingsArgsBuilder.() -> Unit) {
        val toBeMapped = UserProfileUserSettingsCanvasAppSettingsArgsBuilder().applySuspend {
            argument()
        }.build()
        val mapped = of(toBeMapped)
        this.canvasAppSettings = mapped
    }

    /**
     * @param value The Code Editor application settings. See Code Editor App Settings below.
     */
    @JvmName("wvinuwiqqawrwpyi")
    public suspend fun codeEditorAppSettings(`value`: UserProfileUserSettingsCodeEditorAppSettingsArgs?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.codeEditorAppSettings = mapped
    }

    /**
     * @param argument The Code Editor application settings. See Code Editor App Settings below.
     */
    @JvmName("gnrmuhjbdmtkxdqi")
    public suspend fun codeEditorAppSettings(argument: suspend UserProfileUserSettingsCodeEditorAppSettingsArgsBuilder.() -> Unit) {
        val toBeMapped = UserProfileUserSettingsCodeEditorAppSettingsArgsBuilder().applySuspend {
            argument()
        }.build()
        val mapped = of(toBeMapped)
        this.codeEditorAppSettings = mapped
    }

    /**
     * @param value The settings for assigning a custom file system to a user profile. Permitted users can access this file system in Amazon SageMaker Studio. See Custom File System Config below.
     */
    @JvmName("vhyqauqfgcdvmyas")
    public suspend fun customFileSystemConfigs(`value`: List<UserProfileUserSettingsCustomFileSystemConfigArgs>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.customFileSystemConfigs = mapped
    }

    /**
     * @param argument The settings for assigning a custom file system to a user profile. Permitted users can access this file system in Amazon SageMaker Studio. See Custom File System Config below.
     */
    @JvmName("umludgxwjulmmggi")
    public suspend fun customFileSystemConfigs(argument: List<suspend UserProfileUserSettingsCustomFileSystemConfigArgsBuilder.() -> Unit>) {
        val toBeMapped = argument.toList().map {
            UserProfileUserSettingsCustomFileSystemConfigArgsBuilder().applySuspend { it() }.build()
        }
        val mapped = of(toBeMapped)
        this.customFileSystemConfigs = mapped
    }

    /**
     * @param argument The settings for assigning a custom file system to a user profile. Permitted users can access this file system in Amazon SageMaker Studio. See Custom File System Config below.
     */
    @JvmName("nrybyoqtppmqetrj")
    public suspend fun customFileSystemConfigs(vararg argument: suspend UserProfileUserSettingsCustomFileSystemConfigArgsBuilder.() -> Unit) {
        val toBeMapped = argument.toList().map {
            UserProfileUserSettingsCustomFileSystemConfigArgsBuilder().applySuspend { it() }.build()
        }
        val mapped = of(toBeMapped)
        this.customFileSystemConfigs = mapped
    }

    /**
     * @param argument The settings for assigning a custom file system to a user profile. Permitted users can access this file system in Amazon SageMaker Studio. See Custom File System Config below.
     */
    @JvmName("ijhfbscwmcgxjixm")
    public suspend fun customFileSystemConfigs(argument: suspend UserProfileUserSettingsCustomFileSystemConfigArgsBuilder.() -> Unit) {
        val toBeMapped = listOf(
            UserProfileUserSettingsCustomFileSystemConfigArgsBuilder().applySuspend
                { argument() }.build(),
        )
        val mapped = of(toBeMapped)
        this.customFileSystemConfigs = mapped
    }

    /**
     * @param values The settings for assigning a custom file system to a user profile. Permitted users can access this file system in Amazon SageMaker Studio. See Custom File System Config below.
     */
    @JvmName("qbfjgdpcoelmecim")
    public suspend fun customFileSystemConfigs(vararg values: UserProfileUserSettingsCustomFileSystemConfigArgs) {
        val toBeMapped = values.toList()
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.customFileSystemConfigs = mapped
    }

    /**
     * @param value Details about the POSIX identity that is used for file system operations. See Custom Posix User Config below.
     */
    @JvmName("tstsgbodtsyyswqr")
    public suspend fun customPosixUserConfig(`value`: UserProfileUserSettingsCustomPosixUserConfigArgs?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.customPosixUserConfig = mapped
    }

    /**
     * @param argument Details about the POSIX identity that is used for file system operations. See Custom Posix User Config below.
     */
    @JvmName("femxbhkqrisircwb")
    public suspend fun customPosixUserConfig(argument: suspend UserProfileUserSettingsCustomPosixUserConfigArgsBuilder.() -> Unit) {
        val toBeMapped = UserProfileUserSettingsCustomPosixUserConfigArgsBuilder().applySuspend {
            argument()
        }.build()
        val mapped = of(toBeMapped)
        this.customPosixUserConfig = mapped
    }

    /**
     * @param value The default experience that the user is directed to when accessing the domain. The supported values are: `studio::`: Indicates that Studio is the default experience. This value can only be passed if StudioWebPortal is set to ENABLED. `app:JupyterServer:`: Indicates that Studio Classic is the default experience.
     */
    @JvmName("utcsfharxnfugawx")
    public suspend fun defaultLandingUri(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.defaultLandingUri = mapped
    }

    /**
     * @param value The execution role ARN for the user.
     */
    @JvmName("pokoumxwfleobsnq")
    public suspend fun executionRole(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.executionRole = mapped
    }

    /**
     * @param value The settings for the JupyterLab application. See Jupyter Lab App Settings below.
     */
    @JvmName("fuaqbrdnjicxkwgo")
    public suspend fun jupyterLabAppSettings(`value`: UserProfileUserSettingsJupyterLabAppSettingsArgs?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.jupyterLabAppSettings = mapped
    }

    /**
     * @param argument The settings for the JupyterLab application. See Jupyter Lab App Settings below.
     */
    @JvmName("vmblssbsawmyvmbs")
    public suspend fun jupyterLabAppSettings(argument: suspend UserProfileUserSettingsJupyterLabAppSettingsArgsBuilder.() -> Unit) {
        val toBeMapped = UserProfileUserSettingsJupyterLabAppSettingsArgsBuilder().applySuspend {
            argument()
        }.build()
        val mapped = of(toBeMapped)
        this.jupyterLabAppSettings = mapped
    }

    /**
     * @param value The Jupyter server's app settings. See Jupyter Server App Settings below.
     */
    @JvmName("fqyfyijqhmplxtns")
    public suspend fun jupyterServerAppSettings(`value`: UserProfileUserSettingsJupyterServerAppSettingsArgs?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.jupyterServerAppSettings = mapped
    }

    /**
     * @param argument The Jupyter server's app settings. See Jupyter Server App Settings below.
     */
    @JvmName("ngactdhotamfuwcg")
    public suspend fun jupyterServerAppSettings(argument: suspend UserProfileUserSettingsJupyterServerAppSettingsArgsBuilder.() -> Unit) {
        val toBeMapped = UserProfileUserSettingsJupyterServerAppSettingsArgsBuilder().applySuspend {
            argument()
        }.build()
        val mapped = of(toBeMapped)
        this.jupyterServerAppSettings = mapped
    }

    /**
     * @param value The kernel gateway app settings. See Kernel Gateway App Settings below.
     */
    @JvmName("wpyibosowcluvajq")
    public suspend fun kernelGatewayAppSettings(`value`: UserProfileUserSettingsKernelGatewayAppSettingsArgs?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.kernelGatewayAppSettings = mapped
    }

    /**
     * @param argument The kernel gateway app settings. See Kernel Gateway App Settings below.
     */
    @JvmName("ghtdmgmlyogccdnr")
    public suspend fun kernelGatewayAppSettings(argument: suspend UserProfileUserSettingsKernelGatewayAppSettingsArgsBuilder.() -> Unit) {
        val toBeMapped = UserProfileUserSettingsKernelGatewayAppSettingsArgsBuilder().applySuspend {
            argument()
        }.build()
        val mapped = of(toBeMapped)
        this.kernelGatewayAppSettings = mapped
    }

    /**
     * @param value The RSession app settings. See RSession App Settings below.
     */
    @JvmName("flbehyanydubxudc")
    public suspend fun rSessionAppSettings(`value`: UserProfileUserSettingsRSessionAppSettingsArgs?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.rSessionAppSettings = mapped
    }

    /**
     * @param argument The RSession app settings. See RSession App Settings below.
     */
    @JvmName("mwuibsuagnsifsua")
    public suspend fun rSessionAppSettings(argument: suspend UserProfileUserSettingsRSessionAppSettingsArgsBuilder.() -> Unit) {
        val toBeMapped = UserProfileUserSettingsRSessionAppSettingsArgsBuilder().applySuspend {
            argument()
        }.build()
        val mapped = of(toBeMapped)
        this.rSessionAppSettings = mapped
    }

    /**
     * @param value A collection of settings that configure user interaction with the RStudioServerPro app. See RStudioServerProAppSettings below.
     */
    @JvmName("alcyjpqxfxvohqoh")
    public suspend fun rStudioServerProAppSettings(`value`: UserProfileUserSettingsRStudioServerProAppSettingsArgs?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.rStudioServerProAppSettings = mapped
    }

    /**
     * @param argument A collection of settings that configure user interaction with the RStudioServerPro app. See RStudioServerProAppSettings below.
     */
    @JvmName("bprkrexlgtwxnnet")
    public suspend fun rStudioServerProAppSettings(argument: suspend UserProfileUserSettingsRStudioServerProAppSettingsArgsBuilder.() -> Unit) {
        val toBeMapped = UserProfileUserSettingsRStudioServerProAppSettingsArgsBuilder().applySuspend {
            argument()
        }.build()
        val mapped = of(toBeMapped)
        this.rStudioServerProAppSettings = mapped
    }

    /**
     * @param value A list of security group IDs that will be attached to the user.
     */
    @JvmName("ktcupucaujtnonpu")
    public suspend fun securityGroups(`value`: List<String>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.securityGroups = mapped
    }

    /**
     * @param values A list of security group IDs that will be attached to the user.
     */
    @JvmName("qcbprbvpkrxunqac")
    public suspend fun securityGroups(vararg values: String) {
        val toBeMapped = values.toList()
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.securityGroups = mapped
    }

    /**
     * @param value The sharing settings. See Sharing Settings below.
     */
    @JvmName("cmuotietwgnrkfyk")
    public suspend fun sharingSettings(`value`: UserProfileUserSettingsSharingSettingsArgs?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.sharingSettings = mapped
    }

    /**
     * @param argument The sharing settings. See Sharing Settings below.
     */
    @JvmName("gwkhjorkwcxdcaps")
    public suspend fun sharingSettings(argument: suspend UserProfileUserSettingsSharingSettingsArgsBuilder.() -> Unit) {
        val toBeMapped = UserProfileUserSettingsSharingSettingsArgsBuilder().applySuspend {
            argument()
        }.build()
        val mapped = of(toBeMapped)
        this.sharingSettings = mapped
    }

    /**
     * @param value The storage settings for a private space. See Space Storage Settings below.
     */
    @JvmName("irvcxdqhnqqjdvvo")
    public suspend fun spaceStorageSettings(`value`: UserProfileUserSettingsSpaceStorageSettingsArgs?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.spaceStorageSettings = mapped
    }

    /**
     * @param argument The storage settings for a private space. See Space Storage Settings below.
     */
    @JvmName("lnfjfkwsmtdjniec")
    public suspend fun spaceStorageSettings(argument: suspend UserProfileUserSettingsSpaceStorageSettingsArgsBuilder.() -> Unit) {
        val toBeMapped = UserProfileUserSettingsSpaceStorageSettingsArgsBuilder().applySuspend {
            argument()
        }.build()
        val mapped = of(toBeMapped)
        this.spaceStorageSettings = mapped
    }

    /**
     * @param value Whether the user can access Studio. If this value is set to `DISABLED`, the user cannot access Studio, even if that is the default experience for the domain. Valid values are `ENABLED` and `DISABLED`.
     */
    @JvmName("wlxiohnifbmhdwwa")
    public suspend fun studioWebPortal(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.studioWebPortal = mapped
    }

    /**
     * @param value The TensorBoard app settings. See TensorBoard App Settings below.
     */
    @JvmName("pnfwcbfpdkogpaha")
    public suspend fun tensorBoardAppSettings(`value`: UserProfileUserSettingsTensorBoardAppSettingsArgs?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.tensorBoardAppSettings = mapped
    }

    /**
     * @param argument The TensorBoard app settings. See TensorBoard App Settings below.
     */
    @JvmName("whntvykkwggjcdxb")
    public suspend fun tensorBoardAppSettings(argument: suspend UserProfileUserSettingsTensorBoardAppSettingsArgsBuilder.() -> Unit) {
        val toBeMapped = UserProfileUserSettingsTensorBoardAppSettingsArgsBuilder().applySuspend {
            argument()
        }.build()
        val mapped = of(toBeMapped)
        this.tensorBoardAppSettings = mapped
    }

    internal fun build(): UserProfileUserSettingsArgs = UserProfileUserSettingsArgs(
        canvasAppSettings = canvasAppSettings,
        codeEditorAppSettings = codeEditorAppSettings,
        customFileSystemConfigs = customFileSystemConfigs,
        customPosixUserConfig = customPosixUserConfig,
        defaultLandingUri = defaultLandingUri,
        executionRole = executionRole ?: throw PulumiNullFieldException("executionRole"),
        jupyterLabAppSettings = jupyterLabAppSettings,
        jupyterServerAppSettings = jupyterServerAppSettings,
        kernelGatewayAppSettings = kernelGatewayAppSettings,
        rSessionAppSettings = rSessionAppSettings,
        rStudioServerProAppSettings = rStudioServerProAppSettings,
        securityGroups = securityGroups,
        sharingSettings = sharingSettings,
        spaceStorageSettings = spaceStorageSettings,
        studioWebPortal = studioWebPortal,
        tensorBoardAppSettings = tensorBoardAppSettings,
    )
}
