@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.sagemaker.kotlin.inputs

import com.pulumi.aws.sagemaker.inputs.UserProfileUserSettingsCanvasAppSettingsKendraSettingsArgs.builder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.String
import kotlin.Suppress
import kotlin.jvm.JvmName

/**
 *
 * @property status Describes whether the document querying feature is enabled or disabled in the Canvas application. Valid values are `ENABLED` and `DISABLED`.
 */
public data class UserProfileUserSettingsCanvasAppSettingsKendraSettingsArgs(
    public val status: Output<String>? = null,
) :
    ConvertibleToJava<com.pulumi.aws.sagemaker.inputs.UserProfileUserSettingsCanvasAppSettingsKendraSettingsArgs> {
    override fun toJava(): com.pulumi.aws.sagemaker.inputs.UserProfileUserSettingsCanvasAppSettingsKendraSettingsArgs =
        com.pulumi.aws.sagemaker.inputs.UserProfileUserSettingsCanvasAppSettingsKendraSettingsArgs.builder()
            .status(status?.applyValue({ args0 -> args0 })).build()
}

/**
 * Builder for [UserProfileUserSettingsCanvasAppSettingsKendraSettingsArgs].
 */
@PulumiTagMarker
public class UserProfileUserSettingsCanvasAppSettingsKendraSettingsArgsBuilder internal constructor() {
    private var status: Output<String>? = null

    /**
     * @param value Describes whether the document querying feature is enabled or disabled in the Canvas application. Valid values are `ENABLED` and `DISABLED`.
     */
    @JvmName("tcmhcpieqdnrexng")
    public suspend fun status(`value`: Output<String>) {
        this.status = value
    }

    /**
     * @param value Describes whether the document querying feature is enabled or disabled in the Canvas application. Valid values are `ENABLED` and `DISABLED`.
     */
    @JvmName("vcnhfdhxosvbaryy")
    public suspend fun status(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.status = mapped
    }

    internal fun build(): UserProfileUserSettingsCanvasAppSettingsKendraSettingsArgs =
        UserProfileUserSettingsCanvasAppSettingsKendraSettingsArgs(
            status = status,
        )
}
